!CODE

#---+---+---+---+---|---+---+---+---+---|---+---+---+---+---|---+---+---+---+---|---+---+---+---+---|
# 検査対象：ipリテラル（整数）の生成機能、及び、ip2host()/host2ip()/ip2str()/str2ip()の各変換機能
#---+---+---+---+---|---+---+---+---+---|---+---+---+---+---|---+---+---+---+---|---+---+---+---+---|

# データ取得
data = strip(gets())

hostname = split(data,":",0)
ip_str   = split(data,":",1)			# 文字列
ip_str15 = split(data,":",2)			# 文字列(15桁)
ip_ival  = int(split(data,":",3))		# 整数

# 変換の実施
lo       = 127.0.0.1					# 整数リテラル
lo_space = 127 . 0 . 0 . 1				# 整数リテラル(15桁)

cnv1_hostname = ip2host(ip_ival )
cnv1_ip_ival  = host2ip(hostname)

cnv2_ip_str15 = ip2str(ip_ival)
cnv2_ip_ival  = str2ip(ip_str )

# 判定の実施＆結果の出力
if( lo!=0x7F000001 || lo_space!=0x7F000001 ){
	puts("NG!!: ip-leteral\n"); p( lo, lo_space ); exit(1);
}
if( cnv1_hostname!=hostname || cnv1_ip_ival!=ip_ival ){
	puts("NG!!: ip<->host\n"); p( cnv1_hostname, hostname, cnv1_ip_ival, ip_ival ); exit(1);
}
if( cnv2_ip_str15!=ip_str15 || cnv2_ip_ival!=ip_ival ){
	puts("NG!!: ip<->str\n"); p( cnv2_ip_str15, ip_str15, cnv2_ip_ival, ip_ival ); exit(1);
}

puts("OK!!\n")

!DATA
localhost:127.0.0.1:127.  0.  0.  1:0x7F000001
OK!!

localhost:   127.0   .   0.1   :127.  0.  0.  1:0x7F000001
OK!!

cpc:192.168.0.11:192.168.  0. 11:0xC0A8000B
OK!!

mpc:192.168.0.99:192.168.  0. 99:0xC0A80063
OK!!
