!CODE

#---+---+---+---+---|---+---+---+---+---|---+---+---+---+---|---+---+---+---+---|---+---+---+---+---|
# 検査対象：UNIXTIME から 時刻構造体 TM を生成する機能 ( UTC & LTZ )
#---+---+---+---+---|---+---+---+---+---|---+---+---+---+---|---+---+---+---+---|---+---+---+---+---|

# データの取得
str = gets()
t = dbl(split(str,"/",0))				# 実数値 UNIXTIME
z = int(split(str,"/",1))				# 整数値 LTZ_OFFSET

# 変換の実施
LTZ_OFFSET = z
tm_u = t2tm (t)
tm_l = t2ltm(t)

# 結果の出力
print("UTC = %04d-%02d-%02d %02d:%02d:%02d / " , tm_u.year, tm_u.mon , tm_u.day, tm_u.hour, tm_u.min, tm_u.sec)
print("LTZ = %04d-%02d-%02d %02d:%02d:%02d /\n", tm_l.year, tm_l.mon , tm_l.day, tm_l.hour, tm_l.min, tm_l.sec)

!DATA
97445/     0/                                               # UTC
UTC = 1970-01-02 03:04:05 / LTZ = 1970-01-02 03:04:05 /

97445/+32400/                                               # UTC+9[h]
UTC = 1970-01-02 03:04:05 / LTZ = 1970-01-02 12:04:05 /

97445/-32400/                                               # UTC-9[h]
UTC = 1970-01-02 03:04:05 / LTZ = 1970-01-01 18:04:05 /

   -1/     0/                                               # UTC ( 32[Bit] Start - 1 )
UTC = 1969-12-31 23:59:59 / LTZ = 1969-12-31 23:59:59 /

    0/     0/                                               # UTC ( 32[Bit] Start     )
UTC = 1970-01-01 00:00:00 / LTZ = 1970-01-01 00:00:00 /

   +1/     0/                                               # UTC ( 32[Bit] Start + 1 )
UTC = 1970-01-01 00:00:01 / LTZ = 1970-01-01 00:00:01 /

0x7FFFFFFE/0/                                               # UTC ( 32[Bit] End!! - 1 )
UTC = 2038-01-19 03:14:06 / LTZ = 2038-01-19 03:14:06 /

0x7FFFFFFF/0/                                               # UTC ( 32[Bit] End!!     )
UTC = 2038-01-19 03:14:07 / LTZ = 2038-01-19 03:14:07 /

0x80000000/0/                                               # UTC ( 32[Bit] End!! + 1 )
UTC = 2038-01-19 03:14:08 / LTZ = 2038-01-19 03:14:08 /
UTC = 2038-01-19 03:14:07 / LTZ = 2038-01-19 03:14:07 /
