!CODE

#---+---+---+---+---|---+---+---+---+---|---+---+---+---+---|---+---+---+---+---|---+---+---+---+---|
# 検査対象：時刻構造体 TM から UNIXTIME を生成する機能 ( UTC & LTZ )
#---+---+---+---+---|---+---+---+---+---|---+---+---+---+---|---+---+---+---+---|---+---+---+---+---|

# データの取得
str = gets()
s =    (split(str,"/",0))				# 文字列 "YYYY-MM-DD HH:MM:SS"
z = int(split(str,"/",1))				# 整数値 LTZ_OFFSET

# 時刻構造体 TM の設定
LTZ_OFFSET = z
a.year = int(split(s,/[- :]/,0))
a.mon  = int(split(s,/[- :]/,1))
a.day  = int(split(s,/[- :]/,2))
a.hour = int(split(s,/[- :]/,3))
a.min  = int(split(s,/[- :]/,4))
a.sec  = dbl(split(s,/[- :]/,5))

# 変換の実施
u2t =  tm2t(a)
l2t = ltm2t(a)

# 結果の出力
print("U2T = %d / L2T = %d /\n", u2t, l2t )

!DATA
1970-01-02 03:04:05/     0/                                 # UTC
U2T = 97445 / L2T = 97445 /

1970-01-02 03:04:05/+32400/                                 # UTC+9[h]
U2T = 97445 / L2T = 65045 /

1970-01-02 03:04:05/-32400/                                 # UTC-9[h]
U2T = 97445 / L2T = 129845 /

1969-12-31 23:59:59/     0/                                 # UTC ( 32[Bit] Start - 1 )
U2T = -1 / L2T = -1 /

1970-01-01 00:00:00/     0/                                 # UTC ( 32[Bit] Start     )
U2T = 0 / L2T = 0 /

1970-01-01 00:00:01/     0/                                 # UTC ( 32[Bit] Start + 1 )
U2T = 1 / L2T = 1 /

2038-01-19 03:14:06/     0/                                 # UTC ( 32[Bit] End!! - 1 )
U2T = 2147483646 / L2T = 2147483646 /

2038-01-19 03:14:07/     0/                                 # UTC ( 32[Bit] End!!     )
U2T = 2147483647 / L2T = 2147483647 /

2038-01-19 03:14:08/     0/                                 # UTC ( 32[Bit] End!! + 1 )
U2T = 2147483648 / L2T = 2147483648 /
U2T = -2147483648 / L2T = -2147483648 /
