!CODE

#---+---+---+---+---|---+---+---+---+---|---+---+---+---+---|---+---+---+---+---|---+---+---+---+---|
# 検査対象：YYYY,MM,DD & HH,MM,SS から UNIXTIME を生成する機能 ( UTC & LTZ )
#---+---+---+---+---|---+---+---+---+---|---+---+---+---+---|---+---+---+---+---|---+---+---+---+---|

# データ取得
str = gets()
s_uymd = split(str,"/",0)				# 文字列 "YYYY-MM-DD"
s_uhms = split(str,"/",1)				# 文字列 "HH:MM:SS"
s_lymd = split(str,"/",2)				# 文字列 "YYYY-MM-DD"
s_lhms = split(str,"/",3)				# 文字列 "HH:MM:SS"
flag   = split(str,"/",4)				# 文字列 LTZ_OFFSET

# 数値化
loop(i<6){			# UTC: u[] = {YYY,MM,DD,HH,MM,SS}
	tmp  = split(str,/[-:\/]/,i+0)
	u[i] = (i==5) ? dbl(tmp):int(tmp)
}
loop(i<6){			# LTZ: l[] = {YYY,MM,DD,HH,MM,SS}
	tmp  = split(str,/[-:\/]/,i+6)
	l[i] = (i==5) ? dbl(tmp):int(tmp)
}

# LTZ_OFFSET設定
if( flag=="*" )		# Skip
	;
else				# Init
	LTZ_OFFSET = int( flag )

# UTC -> T
ua = ymd2t(u[0],u[1],u[2],u[3],u[4],u[5])
ul = ymd2t(u[0],u[1],u[2])
ur = hms2t(u[3],u[4],u[5])

ua         = rint( ua      )
unixtime_u = rint( ul + ur )
if( ua != unixtime_u ){ p( "NG!! [UTC->T]", ua,unixtime_u,ul,ur ); exit(1); }

print("%d/",unixtime_u)

# LTZ -> T
la = lymd2t(l[0],l[1],l[2],l[3],l[4],l[5])
ll = lymd2t(l[0],l[1],l[2])
lr = lhms2t(l[3],l[4],l[5])

la         = rint( la      )
unixtime_l = rint( ll + lr )
if( la != unixtime_l ){ p( "NG!! [LTZ->T]", la,unixtime_l,ll,lr ); exit(1); }

print("%d\n",unixtime_l)

# MIX(LTZ-LTZ_OFFSET) -> T
ml = ymd2t(l[0],l[1],l[2])
mr = hms2t(l[3],l[4],l[5])

unixtime_m = rint( ml + mr - LTZ_OFFSET )
if( unixtime_u!=unixtime_m || unixtime_l!=unixtime_m ){
	p( "NG!!", unixtime_u,unixtime_l,unixtime_m,ml,mr,LTZ_OFFSET ); exit(1);
}

!DATA
1969-12-31/23:59:59/1970-01-01/08:59:59/*/
-1/-1

1970-01-01/00:00:00/1970-01-01/09:00:00/*/
0/0

1970-01-01/00:00:01/1970-01-01/09:00:01/*/
1/1

1970-01-01/23:59:59/1970-01-02/08:59:59/*/
86399/86399

1970-01-02/00:00:00/1970-01-02/09:00:00/*/
86400/86400

1970-01-02/00:00:01/1970-01-02/09:00:01/*/
86401/86401

1999-12-31/23:59:59/2000-01-01/08:59:59/*/
946684799/946684799

2000-01-01/00:00:00/2000-01-01/09:00:00/*/
946684800/946684800

2000-01-01/00:00:01/2000-01-01/09:00:01/*/
946684801/946684801

2038-01-19/03:14:06/2038-01-19/12:14:06/*/
2147483646/2147483646

2038-01-19/03:14:07/2038-01-19/12:14:07/*/
2147483647/2147483647

2038-01-19/03:14:08/2038-01-19/12:14:08/*/
2147483648/2147483648
-2147483648/-2147483648

2011-08-15/03:00:00/2011-08-15/12:00:00/*/
1313377200/1313377200

2011-08-15/03:00:00/2011-08-15/02:00:00/-3600/
1313377200/1313377200

2011-08-15/03:00:00/2011-08-15/03:00:00/0/
1313377200/1313377200

2011-08-15/03:00:00/2011-08-15/04:00:00/+3600/
1313377200/1313377200
