!CODE

#---+---+---+---+---|---+---+---+---+---|---+---+---+---+---|---+---+---+---+---|---+---+---+---+---|
# 検査対象：UNIXTIME から YYYY,MM,DD & HH,MM,SS を生成する機能 ( UTC & LTZ )
#---+---+---+---+---|---+---+---+---+---|---+---+---+---+---|---+---+---+---+---|---+---+---+---+---|

# データ取得
str = gets()
s_sec = split(str,"/",0)				# 文字列 UNIXTIME
flag  = split(str,"/",1)				# 文字列 LTZ_OFFSET

# 数値化
t_sec = int( s_sec )					# UNIXTIME

# LTZ_OFFSET設定
if( flag=="*" )		# Skip
	;
else				# Init
	LTZ_OFFSET = int( flag )

# T -> UTC
( year, mon, day, hour, min, sec ) = t2ymd(t_sec)
( u_year, u_mon, u_day ) = t2ymd(t_sec)
( u_hour, u_min, u_sec ) = t2hms(t_sec)

if( year!=u_year || mon!=u_mon || day!=u_day || hour!=u_hour || min!=u_min || sec!=u_sec ){
	p( "NG!! [T->UTC]" )
}

print("%02d-%02d-%02d %02d:%02d:%02d [UTC] * ", u_year, u_mon, u_day, u_hour, u_min, u_sec )

# T -> LTZ
( year, mon, day, hour, min, sec ) = t2lymd(t_sec)
( l_year, l_mon, l_day ) = t2lymd(t_sec)
( l_hour, l_min, l_sec ) = t2lhms(t_sec)

if( year!=l_year || mon!=l_mon || day!=l_day || hour!=l_hour || min!=l_min || sec!=l_sec ){
	p( "NG!! [T->LTZ]" )
}

print("%02d-%02d-%02d %02d:%02d:%02d [LTZ]\n" , l_year, l_mon, l_day, l_hour, l_min, l_sec )

!DATA
-1/*/
1969-12-31 23:59:59 [UTC] * 1970-01-01 08:59:59 [LTZ]

0/*/
1970-01-01 00:00:00 [UTC] * 1970-01-01 09:00:00 [LTZ]

1/*/
1970-01-01 00:00:01 [UTC] * 1970-01-01 09:00:01 [LTZ]

86399/*/
1970-01-01 23:59:59 [UTC] * 1970-01-02 08:59:59 [LTZ]

86400/*/
1970-01-02 00:00:00 [UTC] * 1970-01-02 09:00:00 [LTZ]

86401/*/
1970-01-02 00:00:01 [UTC] * 1970-01-02 09:00:01 [LTZ]

946684799/*/
1999-12-31 23:59:59 [UTC] * 2000-01-01 08:59:59 [LTZ]

946684800/*/
2000-01-01 00:00:00 [UTC] * 2000-01-01 09:00:00 [LTZ]

946684801/*/
2000-01-01 00:00:01 [UTC] * 2000-01-01 09:00:01 [LTZ]

2147483646/*/
2038-01-19 03:14:06 [UTC] * 2038-01-19 12:14:06 [LTZ]
2038-01-19 03:14:06 [UTC] * 1901-12-14 05:45:50 [LTZ]

2147483647/*/
2038-01-19 03:14:07 [UTC] * 2038-01-19 12:14:07 [LTZ]
2038-01-19 03:14:07 [UTC] * 1901-12-14 05:45:51 [LTZ]

2147483648/*/
2038-01-19 03:14:08 [UTC] * 2038-01-19 12:14:08 [LTZ]
2038-01-19 03:14:07 [UTC] * 1901-12-14 05:45:51 [LTZ]

1313377200/*/
2011-08-15 03:00:00 [UTC] * 2011-08-15 12:00:00 [LTZ]

1313377200/-3600/
2011-08-15 03:00:00 [UTC] * 2011-08-15 02:00:00 [LTZ]

1313377200/0/
2011-08-15 03:00:00 [UTC] * 2011-08-15 03:00:00 [LTZ]

1313377200/+3600/
2011-08-15 03:00:00 [UTC] * 2011-08-15 04:00:00 [LTZ]
