!CODE

#---+---+---+---+---|---+---+---+---+---|---+---+---+---+---|---+---+---+---+---|---+---+---+---+---|
# 検査対象：文字列 から UNIXTIME を生成する機能 ( UTC & LTZ )
#---+---+---+---+---|---+---+---+---+---|---+---+---+---+---|---+---+---+---+---|---+---+---+---+---|

# データ取得（文字列）
str = gets()
su_ymd = split(str,"/",0);
su_hms = split(str,"/",1);
sl_ymd = split(str,"/",2);
sl_hms = split(str,"/",3);
flag   = split(str,"/",4)				# TZ_OFFSET

# LTZ_OFFSET設定
if( flag=="*" )		# Skip
	;
else				# Init
	LTZ_OFFSET = int( flag )

### vdate() & vtime() ###
#t_utc1 = vdate (su_ymd) +  vtime(su_hms)					# UNIXTIME
#t_ltz1 = lvdate(sl_ymd) + lvtime(sl_hms)					# UNIXTIME
t_utc1 =  ymd2t(su_ymd) +  hms2t(su_hms)					# UNIXTIME
t_ltz1 = lymd2t(sl_ymd) + lhms2t(sl_hms)					# UNIXTIME

### strptime() ###
t_utc2  = strptime ("%Y-%m-%d %H:%M:%S",su_ymd+" "+su_hms)	# UNIXTIME
t_ltz2  = strlptime("%Y-%m-%d %H:%M:%S",sl_ymd+" "+sl_hms)	# UNIXTIME

# 正常性検査＆結果出力
if( t_utc1!=t_utc2 || t_ltz1!=t_ltz2 ){
	p( "NG!!", t_utc1,t_utc2, t_ltz1,t_ltz2 ); exit(1);
}
print("%d/%d\n",t_utc1,t_ltz1)

!DATA
1969-12-31/23:59:59/1970-01-01/08:59:59/*/
-1/-1

1970-01-01/00:00:00/1970-01-01/09:00:00/*/
0/0

1970-01-01/00:00:01/1970-01-01/09:00:01/*/
1/1

1970-01-01/23:59:59/1970-01-02/08:59:59/*/
86399/86399

1970-01-02/00:00:00/1970-01-02/09:00:00/*/
86400/86400

1970-01-02/00:00:01/1970-01-02/09:00:01/*/
86401/86401

1999-12-31/23:59:59/2000-01-01/08:59:59/*/
946684799/946684799

2000-01-01/00:00:00/2000-01-01/09:00:00/*/
946684800/946684800

2000-01-01/00:00:01/2000-01-01/09:00:01/*/
946684801/946684801

2038-01-19/03:14:06/2038-01-19/12:14:06/*/
2147483646/2147483646

2038-01-19/03:14:07/2038-01-19/12:14:07/*/
2147483647/2147483647

2038-01-19/03:14:08/2038-01-19/12:14:08/*/		# -1 must be bug in Cygwin32
2147483648/2147483648
-2147483648/-1

2011-08-15/03:00:00/2011-08-15/12:00:00/*/
1313377200/1313377200

2011-08-15/03:00:00/2011-08-15/02:00:00/-3600/
1313377200/1313377200

2011-08-15/03:00:00/2011-08-15/03:00:00/0/
1313377200/1313377200

2011-08-15/03:00:00/2011-08-15/04:00:00/+3600/
1313377200/1313377200
