!CODE

#---+---+---+---+---|---+---+---+---+---|---+---+---+---+---|---+---+---+---+---|---+---+---+---+---|
# 検査対象：UNIXTIME から 文字列 を生成する機能 ( UTC & LTZ )
#---+---+---+---+---|---+---+---+---+---|---+---+---+---+---|---+---+---+---+---|---+---+---+---+---|

# データ取得（文字列）
str = gets()
s_sec = split(str,"/",0)				# UNIXTIME
flag  = split(str,"/",1)				# LTZ_OFFSET

# 数値化
t_sec = int( s_sec )

# LTZ_OFFSET設定
if( flag=="*" )		# Skip
	;
else				# Init
	LTZ_OFFSET = int( flag )

### sdate() & stime() ###
s_utc1 = sdate (t_sec) + " " + stime (t_sec)				# UTC "YYYY-MM-DD HH:MM:SS"
s_ltz1 = lsdate(t_sec) + " " + lstime(t_sec)				# LTZ "YYYY-MM-DD HH:MM:SS"

### strftime() ###
s_utc2 =strftime ("%F",t_sec) + " " + strftime ("%T",t_sec)	# UTC "YYYY-MM-DD HH:MM:SS"
s_ltz2 =strlftime("%F",t_sec) + " " + strlftime("%T",t_sec)	# LTZ "YYYY-MM-DD HH:MM:SS"

# 正常性検査＆結果出力
if( s_utc1!=s_utc2 || s_ltz1!=s_ltz2 ){
	p( "NG!!", s_utc1,s_utc2, s_ltz1,s_ltz2 ); exit(1);
}
print("%s [UTC] * %s [LTZ]\n", s_utc1, s_ltz1 )

!DATA
-1/*/
1969-12-31 23:59:59 [UTC] * 1970-01-01 08:59:59 [LTZ]

0/*/
1970-01-01 00:00:00 [UTC] * 1970-01-01 09:00:00 [LTZ]

1/*/
1970-01-01 00:00:01 [UTC] * 1970-01-01 09:00:01 [LTZ]

86399/*/
1970-01-01 23:59:59 [UTC] * 1970-01-02 08:59:59 [LTZ]

86400/*/
1970-01-02 00:00:00 [UTC] * 1970-01-02 09:00:00 [LTZ]

86401/*/
1970-01-02 00:00:01 [UTC] * 1970-01-02 09:00:01 [LTZ]

946684799/*/
1999-12-31 23:59:59 [UTC] * 2000-01-01 08:59:59 [LTZ]

946684800/*/
2000-01-01 00:00:00 [UTC] * 2000-01-01 09:00:00 [LTZ]

946684801/*/
2000-01-01 00:00:01 [UTC] * 2000-01-01 09:00:01 [LTZ]

2147483646/*/
2038-01-19 03:14:06 [UTC] * 2038-01-19 12:14:06 [LTZ]
2038-01-19 03:14:06 [UTC] * 1901-12-14 05:45:50 [LTZ]

2147483647/*/
2038-01-19 03:14:07 [UTC] * 2038-01-19 12:14:07 [LTZ]
2038-01-19 03:14:07 [UTC] * 1901-12-14 05:45:51 [LTZ]

2147483648/*/
2038-01-19 03:14:08 [UTC] * 2038-01-19 12:14:08 [LTZ]
2038-01-19 03:14:07 [UTC] * 1901-12-14 05:45:51 [LTZ]

1313377200/*/
2011-08-15 03:00:00 [UTC] * 2011-08-15 12:00:00 [LTZ]

1313377200/-3600/
2011-08-15 03:00:00 [UTC] * 2011-08-15 02:00:00 [LTZ]

1313377200/0/
2011-08-15 03:00:00 [UTC] * 2011-08-15 03:00:00 [LTZ]

1313377200/+3600/
2011-08-15 03:00:00 [UTC] * 2011-08-15 04:00:00 [LTZ]
