!CODE

#---+---+---+---+---|---+---+---+---+---|---+---+---+---+---|---+---+---+---+---|---+---+---+---+---|
# 検査対象：現在時刻 UNIXTIME と プロセス時刻 を取得する機能
#---+---+---+---+---|---+---+---+---+---|---+---+---+---+---|---+---+---+---+---|---+---+---+---+---|

# 現在時刻の取得
u1 = `date "+%s"`
t = int(time()); us="${t}\n"
u2 = `date "+%s"`

# プロセス時刻の取得
p1 = ptime()
sleep(1); ERR = 0.100					# MAX Error Tolerance [Sec]
p2 = ptime()

# 正常性の検査
if( us!=u1 && us!=u2                                               ){ p("NG1",us,u1,u2); exit(1); }
if( p2.ptime - p1.ptime < 1.0-ERR || 1.0+ERR < p2.ptime - p1.ptime ){ p("NG2",   p1,p2); exit(1); }
if( p2.utime - p1.utime > ERR                                      ){ p("NG3",   p1,p2); exit(1); }
if( p2.stime - p1.stime > ERR                                      ){ p("NG4",   p1,p2); exit(1); }

# 結果の出力
print("OK!!\n")

!DATA
***
OK!!
