;;
;(rule seq immediate-flag back)
(define rk-context-new
  (lambda (rule immediate-commit back)
    (let ((res (copy-list '(() () () ()))))
      (rk-context-set-rule! res rule)
      (rk-context-set-immediate-commit! res
					immediate-commit)
      (rk-context-set-back-match! res back)
      res)))

;;
(define rk-context-rule
  (lambda (rkc)
    (car (nthcdr 0 rkc))))
;;
(define rk-context-set-rule!
  (lambda (rkc rule)
    (set-car! (nthcdr 0 rkc) rule)))

(define rk-context-seq
  (lambda (rkc)
    (car (nthcdr 1 rkc))))
(define rk-context-set-seq!
  (lambda (rkc seq)
    (set-car! (nthcdr 1 rkc) seq)))

(define rk-context-immediate-commit
  (lambda (rkc)
    (car (nthcdr 2 rkc))))
(define rk-context-set-immediate-commit!
  (lambda (rkc flag)
    (set-car! (nthcdr 2 rkc) flag)))
(define rk-context-back-match
  (lambda (rkc)
    (car (nthcdr 3 rkc))))
(define rk-context-set-back-match!
  (lambda (rkc flag)
    (set-car! (nthcdr 3 rkc) flag)))
;;
(define rk-check-back-partial
  (lambda (rule left right)
    (if left
	(if (and
	     (rk-find-seq (reverse left) rule)
	     (rk-find-partial-seq right rule))
	    #t
	    (rk-check-back-partial
	     rule
	     (cdr left)
	     (cons (car left) right)))
	#f)))
;;
(define rk-find-longest-match
  (lambda (rule seq)
    (if seq
	(if (rk-find-seq seq rule)
	    seq
	    (rk-find-longest-match
	     (reverse (cdr (reverse seq))) rule))
	nil)))
;;
(define rk-check-back-commit
  (lambda (rule seq)
    (let* ((len (length seq))
	   (partial (rk-find-seq-partial seq rule))
	   (longest (rk-find-longest-match rule seq))
	   (c (rk-find-seq longest rule))
	   (t (rk-find-seq-partial longest rule)))
      (and
       (if (> len 0)
	   #t
	   #f)
       (if (and c t)
	   #f
	   #t)
       (if (not partial)
	   (begin
	     #f)
	   #t)
       (rk-find-seq longest rule)))))



;;
(define rk-partial-back-match
  (lambda (rule s)
    (let ((rs (reverse s)))
      (if rs
	  (rk-check-back-partial rule (list (car rs)) (cdr rs))
	  nil))))
;;
(define rk-partial-seq?
  (lambda (rkc s)
    (rk-find-partial-seq
     (reverse s) (rk-context-rule rkc))))
;; API
(define rk-partial?
  (lambda (rkc)
    (if (rk-context-back-match rkc)
	(rk-partial-back-partial
	 (rk-context-rule rkc)
	 (rk-context-seq rkc))
	(rk-partial-seq?
	 rkc
	 (rk-context-seq rkc)))))

;; API
(define rk-current-seq
  (lambda (rkc)
    (let* ((s (rk-context-seq rkc))
	   (rule (rk-context-rule rkc)))
      (rk-find-seq (reverse s) rule))))

(define rk-flush
  (lambda (context)
    (rk-context-set-seq! context ())))

(define rk-backspace
  (lambda (context)
    (if
     (> (length (rk-context-seq context)) 0)
     (begin
       (rk-context-set-seq! context
		 (cdr (rk-context-seq context)))
       #t)
     #f)))
 
(define rk-delete
  (lambda (context)
    (if
     (> (length (rk-context-seq context)) 0)
     (begin
       (rk-context-set-seq! context
		 (cdr (rk-context-seq context)))
       #t)
     #f)))

(define rk-proc-tail
  (lambda (context seq)
    (let* ((rule (rk-context-rule context))
	   (old-seq
	    (rk-find-seq
	     (reverse (rk-context-seq context)) rule))
	   (res nil))
      (if old-seq
	  (begin
	    (rk-flush context)
	    (rk-push-key! context (car seq))
	    (set! res (cadr old-seq)))
	  (if (rk-context-seq context)
	      (begin
		(rk-flush context)
		(set! res
		      (rk-push-key! context (car seq))))))
      res)))


(define rk-proc-end-seq
  (lambda (context seq s)
    (if (rk-context-immediate-commit context)
	(begin
	  (rk-context-set-seq! context (cdar seq))
	  (cadr seq))
	(begin
	  (rk-context-set-seq! context s)
	  nil))))
;;
(define rk-expect
  (lambda (rkc)
    (let
	((s (reverse (rk-context-seq rkc)))
	 (rule (rk-context-rule rkc)))
      (rk-expect-seq s rule))))
;;
(define rk-push-key-back-match
  (lambda (rkc key)
    (let*
	((s (rk-context-seq rkc))
	 (s (cons key s))
	 (rule (rk-context-rule rkc))
	 (seq (rk-find-seq (reverse s) rule))
	 (res))
      (if (rk-partial-back-match rule s)
	  (rk-context-set-seq! rkc s))
      ())))

(define rk-push-key-front-match
  (lambda (rkc key)
    (let*
	((s (rk-context-seq rkc))
	 (s (cons key s))
	 (rule (rk-context-rule rkc))
	 (seq (rk-find-seq (reverse s) rule))
	 (res))
      (set!
       res
       (if (rk-partial-seq? rkc s)
	   (begin
	     (rk-context-set-seq! rkc s)
	     nil)
	   (if seq
	       (rk-proc-end-seq rkc seq s)
	       (rk-proc-tail rkc s))))
      res)))

(define rk-push-key!
  (lambda (rkc key)
    (if (rk-context-back-match rkc)
	(rk-push-key-back-match rkc key)
	(rk-push-key-front-match rkc key))))
;;
(define rk-pending
  (lambda (c)
    (string-list-concat
     (rk-context-seq c))))
