/*
 * mem_dic ΥåԤ
 *
 * åɤߤʸȵѴѤΥե饰(is_reverse)
 * Ĥ򥭡Ȥ롣
 *
 * Copyright (C) 2000-2006 TABATA Yusuke
 */
#include <stdlib.h>

#include <alloc.h>
#include "dic_main.h"
#include "mem_dic.h"

static allocator mem_dic_ator;

static void
dic_ent_dtor(void *p)
{
  struct dic_ent *de = p;
  if (de->str.str) {
    free(de->str.str);
  }
}

static void
seq_ent_dtor(void *p)
{
  struct seq_ent *seq = p;
  int i;
  /**/
  for (i = 0; i < seq->nr_dic_ents; i++) {
    anthy_sfree(seq->md->dic_ent_allocator, seq->dic_ents[i]);
  }
  if (seq->nr_dic_ents) {
    free(seq->dic_ents);
  }
  /**/
  free(seq->str.str);
}

static void
mem_dic_dtor(void *p)
{
  struct mem_dic * md = p;
  anthy_free_allocator(md->seq_ent_allocator);
  anthy_free_allocator(md->dic_ent_allocator);
}

/** xstrбseq_entΥݤ */
static struct seq_ent *
alloc_seq_ent_by_xstr(struct mem_dic * md, xstr *x, int is_reverse)
{
  struct seq_ent *se;
  int mask = anthy_get_current_session_mask();
  se = (struct seq_ent *)anthy_smalloc(md->seq_ent_allocator);
  se->flags = F_NONE;
  if (is_reverse) {
    se->seq_type = ST_REVERSE;
  } else {
    se->seq_type = ST_NONE;
  }
  se->md = md;
  se->str.len = x->len;
  /**/
  se->nr_dic_ents = 0;
  se->dic_ents = NULL;
  /**/
  se->nr_compound_ents = 0;

  se->str.str = anthy_xstr_dup_str(x);
  se->mask = mask;
  return se;
}

/* ϥåؿȤꤢƤȡ */
static int
hash_function(xstr *xs)
{
  if (xs->len) {
    return xs->str[0]% HASH_SIZE;
  }
  return 0;
}

/** xstrбseq_ent֤ */
struct seq_ent *
anthy_mem_dic_alloc_seq_ent_by_xstr(struct mem_dic * md, xstr *xs,
				    int is_reverse)
{
  struct seq_ent *se;
  int h;
  /* åˤФ֤ */
  se = anthy_mem_dic_find_seq_ent_by_xstr(md, xs, is_reverse);
  if (se) {
    return se;
  }
  /* åˤ̵ΤǺ */
  se = alloc_seq_ent_by_xstr(md, xs, is_reverse);

  /* mem_dicˤĤʤ */
  h = hash_function(xs);
  se->next = md->seq_ent_hash[h];
  md->seq_ent_hash[h] = se;

  return se;
}

static int
compare_seq_ent(struct seq_ent *seq, xstr *xs, int is_reverse)
{
  /* ޤɤ餫ѴѤΥȥ꤫å */
  if (seq->seq_type & ST_REVERSE) {
    if (!is_reverse) {
      return 1;
    }
  } else {
    if (is_reverse) {
      return 1;
    }
  }
  /* ʸ */
  return anthy_xstrcmp(&seq->str, xs);
}

/*** mem_dic椫ʸбseq_ent*
 * */
struct seq_ent *
anthy_mem_dic_find_seq_ent_by_xstr(struct mem_dic * md, xstr *xs,
				   int is_reverse)
{
  struct seq_ent *sn;
  int h;
  h = hash_function(xs);
  for (sn = md->seq_ent_hash[h]; sn; sn = sn->next) {
    if (!compare_seq_ent(sn, xs, is_reverse)){
      int mask;
      mask = anthy_get_current_session_mask();
      sn->mask |= mask;
      return sn;
    }
  }
  return 0;
}

void
anthy_mem_dic_release_seq_ent(struct mem_dic * md, xstr *xs, int is_reverse)
{
  struct seq_ent *sn;
  struct seq_ent **sn_prev_p;
  int h;

  h = hash_function(xs);
  sn_prev_p = &md->seq_ent_hash[h];
  for (sn = md->seq_ent_hash[h]; sn; sn = sn->next) {
    if (!compare_seq_ent(sn, xs, is_reverse)){
      *sn_prev_p = sn->next;
      anthy_sfree(md->seq_ent_allocator, sn);
      return;
    } else {
      sn_prev_p = &sn->next;
    }
  }
}

void
anthy_invalidate_seq_ent_mask(struct mem_dic *md, int mask)
{
  int i;
  struct seq_ent *n;
  for (i = 0; i < HASH_SIZE; i++) {
    for (n = md->seq_ent_hash[i]; n; n = n->next) {
      n->mask &= mask;
    }
  }
}

/** seq_entdic_entɲä */
void
anthy_mem_dic_push_back_dic_ent(struct seq_ent *se, int is_compound,
				xstr *xs, wtype_t wt,
				const char *wt_name, int freq)
{
  struct dic_ent *de;
  de = anthy_smalloc(se->md->dic_ent_allocator);
  de->type = wt;
  de->wt_name = wt_name;
  de->freq = freq;
  de->order = 0;
  de->is_compound = is_compound;
  de->str.len = xs->len;
  de->str.str = anthy_xstr_dup_str(xs);

  if (is_compound) {
    se->nr_compound_ents ++;
  }

  /* order׻ */
  if (se->nr_dic_ents > 0) {
    struct dic_ent *prev_de = se->dic_ents[se->nr_dic_ents-1];
    if (anthy_wtype_equal(prev_de->type, de->type) &&
	prev_de->freq > de->freq) {
      de->order = prev_de->order + 1;
    }
  }

  /* ɲä */
  se->nr_dic_ents ++;
  se->dic_ents = realloc(se->dic_ents,
			 sizeof(struct dic_ent *)*se->nr_dic_ents);
  se->dic_ents[se->nr_dic_ents-1] = de;
}

struct mem_dic *
anthy_create_mem_dic(void)
{
  int i;
  struct mem_dic *md;

  md = anthy_smalloc(mem_dic_ator);
  for (i = 0; i < HASH_SIZE; i++) {
    md->seq_ent_hash[i] = NULL;
  }
  
  md->seq_ent_allocator = 
    anthy_create_allocator(sizeof(struct seq_ent),
			   seq_ent_dtor);
  md->dic_ent_allocator =
    anthy_create_allocator(sizeof(struct dic_ent),
			   dic_ent_dtor);
  anthy_init_sessions(md);

  return md;
}

void
anthy_release_mem_dic(struct mem_dic * d)
{
  anthy_sfree(mem_dic_ator, d);
}

void
anthy_shrink_mem_dic(struct mem_dic * md)
{
  int i;
  struct seq_ent *n, *n_next;
  struct seq_ent **n_prev_p;

  for ( i = 0 ; i < HASH_SIZE ; i ++){
    n_prev_p = &md->seq_ent_hash[i];
    for (n = md->seq_ent_hash[i]; n; n = n_next) {
      n_next = n->next;
      if (!n->mask) {
	/*ɤΥåˤäƤȤƤʤ*/
	*n_prev_p = n_next;
	anthy_sfree(md->seq_ent_allocator, n);
      } else
	n_prev_p = &n->next;
    }
  }
}

void
anthy_init_mem_dic(void)
{
  mem_dic_ator = anthy_create_allocator(sizeof(struct mem_dic),
					mem_dic_dtor);
}

void
anthy_quit_mem_dic(void)
{
  anthy_free_allocator(mem_dic_ator);
}
