/*
 * ddicΥåºݤ˹Ԥ
 *
 * Copyright (C) 2000-2003 TABATA Yusuke
 */
#include <stdlib.h>

#include <alloc.h>
#include "dic_main.h"
#include "ddic_tree.h"

static allocator ddic_ator;

static void
seq_node_dtor(void *p)
{
  struct seq_node *s = p;
  int i;
  for (i = 0; i < s->data.nr_dic_ents; i++) {
    free(s->data.dic_ents[i]->str.str);
    free(s->data.dic_ents[i]);
  }
  if (s->data.nr_dic_ents) {
    free(s->data.dic_ents);
  }
  free(s->str.str);
}

static void
ddic_dtor(void *p)
{
  ddic_t d = p;
  anthy_free_allocator(d->node_allocator);
}

/** ̵ä0֤ */
static struct seq_node *
alloc_seq_node_by_xstr(ddic_t d, xstr *x)
{
  struct seq_node *s;
  int mask = anthy_get_current_session_mask();
  s = (struct seq_node *)anthy_smalloc(d->node_allocator);
  s->data.dic_ents = 0;
  s->data.flags = F_NONE;
  s->data.nr_dic_ents = 0;
  s->data.node_type = 0;
  s->str.len = x->len;
  s->str.str = anthy_xstr_dup_str(x);
  s->mask = mask;
  return s;
}

/* ϥåؿȤꤢƤȡ */
static int
hash_function(xstr *x)
{
  if (x->len) {
    return x->str[0]% HASH_SIZE;
  }
  return 0;
}

struct seq_ent *
anthy_ddic_alloc_seq_ent_by_xstr(ddic_t d, xstr *x)
{
  struct seq_node *n;
  struct seq_ent *e;
  struct ddic_handle *dd=d;
  int h;
  /* åˤФ֤ */
  e = anthy_ddic_find_seq_ent_by_xstr(d, x);
  if (e) {
    return e;
  }
  /* åˤ̵ä */
  n = alloc_seq_node_by_xstr(d, x);

  h = hash_function(x);
  n->next = dd->root_node[h];
  dd->root_node[h] = n;

  return &n->data;
}

struct seq_ent *
anthy_ddic_find_seq_ent_by_xstr(ddic_t d, xstr *x)
{
  struct seq_node *c;
  struct ddic_handle *dh = d;
  int h;
  h = hash_function(x);
  for (c = dh->root_node[h]; c; c= c->next) {
    if (!anthy_xstrcmp(&c->str, x)){
      int mask;
      mask = anthy_get_current_session_mask();
      c->mask |= mask;
      return &c->data;
    }
  }
  return 0;
}

void
anthy_ddic_release_seq_ent(ddic_t d, xstr *x)
{
  struct seq_node *c;
  struct seq_node **c_prev_p;
  struct ddic_handle *dh = d;
  int h;

  h = hash_function(x);
  c_prev_p = &dh->root_node[h];
  for (c = dh->root_node[h]; c; c = c->next) {
    if (!anthy_xstrcmp(&c->str, x)) {
      *c_prev_p = c->next;
      anthy_sfree(d->node_allocator, c);
      return;
    } else
      c_prev_p = &c->next;
  }
}

void
anthy_invalidate_seq_node_mask(ddic_t d, int mask)
{
  int i;
  struct seq_node *n;
  for (i = 0; i < HASH_SIZE; i++) {
    for (n = d->root_node[i]; n; n = n->next) {
      n->mask &= mask;
    }
  }
}

/** seq_entdic_entɲä */
void
anthy_ddic_push_back_dic_ent(struct seq_ent *se, xstr *xs,
			     wtype_t wt, int freq, int id)
{
  struct dic_ent *de;
  de = malloc(sizeof(struct dic_ent));
  de->type = wt;
  de->freq = freq;
  de->id = id;
  de->str.len = xs->len;
  de->str.str = anthy_xstr_dup_str(xs);

  se->nr_dic_ents ++;
  se->dic_ents = realloc(se->dic_ents,
			 sizeof(struct dic_ent *)*se->nr_dic_ents);
  se->dic_ents[se->nr_dic_ents-1] = de;
}

ddic_t
anthy_create_ddic(void)
{
  int i;
  struct ddic_handle *de;

  de = anthy_smalloc(ddic_ator);
  for (i = 0; i < HASH_SIZE; i++) {
    de->root_node[i] = NULL;
  }
  
  de->node_allocator = 
    anthy_create_allocator(sizeof(struct seq_node),
			   seq_node_dtor);
  anthy_init_sessions(de);

  return de;
}

void
anthy_release_ddic(ddic_t d)
{
  anthy_sfree(ddic_ator, d);
}

void
anthy_shrink_ddic(ddic_t d)
{
  int i;
  struct seq_node *n, *n_next;
  struct seq_node **n_prev_p;

  for ( i = 0 ; i < HASH_SIZE ; i ++){
    n_prev_p = &d->root_node[i];
    for (n = d->root_node[i]; n; n = n_next) {
      n_next = n->next;
      if (!n->mask) {
	/*ɤΥåˤäƤȤƤʤ*/
	*n_prev_p = n_next;
	anthy_sfree(d->node_allocator, n);
      } else
	n_prev_p = &n->next;
    }
  }
}

void
anthy_init_ddic(void)
{
  ddic_ator = anthy_create_allocator(sizeof(struct ddic_handle),
				     ddic_dtor);
}

void
anthy_quit_ddic(void)
{
  anthy_free_allocator(ddic_ator);
}
