/*
 * ΥåԤ
 * ºݤ˥å夹Τddic_ent.c
 * (ΤsdicʣĤ⤷ʤ)
 * ĿѤμⰷ
 *
 * Copyright (C) 2000-2002 TABATA Yusuke
 *
 * $Id: dic_cache.c,v 1.19 2002/11/05 15:38:58 yusuke Exp $
 */
#include <stdlib.h>
#include <stdio.h>

#include <alloc.h>
#include <wtype.h>
#include <record.h>
#include <dic.h>
#include <conf.h>
#include <logger.h>

#include "xchar.h"
#include "dic_main.h"
#include "dic_cache.h"
#include "dic_ent.h"
#include "dic_personality.h"

/* personalityǶͭ뼭 */
static struct global_cache g_dic_cache;

/* ɽ */
static struct conjugate_table{
  xchar t[2];
  int cc;
  int ct;
  int cst;
}ctab[]={
#include "ctab.h"
};


/*
 * ̤Υưϳɽ˴𤤤̤˽򤹤Τ
 * Ǥϡ֤ñȤǽФ 
 */
static void
fill_sv_conjugated_ent(xstr *x, struct seq_ent *s,
		       struct conjugate_table *c)
{
  wtype_t wt = anthy_wt_all;
  anthy_wtype_set_pos(&wt, POS_V);
  anthy_wtype_set_cc(&wt, CC_SV);
  anthy_wtype_set_ct(&wt, c->ct);
  anthy_wtype_set_cst(&wt, c->cst);
  anthy_ddic_push_back_dic_ent(s, x, wt, 1, 0);
}

/*
 * ñγѤμबɽΥȥȰפñ򼭽񤫤õ
 */
static void
fill_conjugated_ent(xstr *x, struct seq_ent *s)
{
  struct conjugate_table *p;
  xchar l1 = 0, l2 = 0;
  xstr z;
  xstr tail;/* Ѹ */
  z.str = x->str;
  z.len = x->len;

  /* Ǹΰʸʸ */
  if (x->len > 0) {
    l1 = x->str[x->len - 1];
    if (x->len > 1) {
      l2 = x->str[x->len - 2];
    }
  }

  /* ɽγƳѥѥФ */
  for (p = &ctab[0]; p->t[0] >= 0; p++) {
    tail.str = p->t;
    if (p->t[0] == 0) {
      /* 촴ΤߤǤڤ */
      z.len = x->len;
      anthy_sdic_fill_seq_ent_by_xstr(g_dic_cache.dic,
				      &z, s, 0, p->cc, p->ct, p->cst);
    }else if (p->t[1] == 0) {
      /* Ѥʬʸ */
      tail.len = 1;
      if (l1 == p->t[0]) {
	z.len = x->len - 1;
	anthy_sdic_fill_seq_ent_by_xstr(g_dic_cache.dic,
					&z, s, &tail, p->cc, p->ct, p->cst);
	if (p->cc == CC_SV && z.len == 0) {
	  fill_sv_conjugated_ent(x, s, p);
	}
      }
    }else{
      tail.len = 2;
      /* Ѥʬʸ */
      if (l2 == p->t[0] && l1 == p->t[1]) {
	z.len = x->len - 2;
	anthy_sdic_fill_seq_ent_by_xstr(g_dic_cache.dic,
					&z, s, &tail, p->cc, p->ct, p->cst);
	if (p->cc == CC_SV && z.len == 0) {
	  fill_sv_conjugated_ent(x, s, p);
	}
      }
    }
  }
}

static void
calc_seq_flags(struct seq_ent *e)
{
  int i;

  /* Ƥμ񥨥ȥФ */
  for (i = 0; i < e->nr_dic_ents; i++) {
    int p;
    p = anthy_wtype_get_pos(e->dic_ents[i]->type);
    switch (p) {
    case POS_NOUN:
    {
      int c;
      c = anthy_wtype_get_cos(e->dic_ents[i]->type);
      if (c == COS_NN) {
	e->flags |= NF_NUM;
      }else if (c == COS_JN) {
	int s;
	s = anthy_wtype_get_scos(e->dic_ents[i]->type);
	if (s == SCOS_FSTNAME) {
	  e->flags |= NF_FSTNAME;
	} else if (s == SCOS_FAMNAME) {
	  e->flags |= NF_FAMNAME;
	} else {
	  e->flags |= NF_UNSPECNAME;
	}
      }
    }
    break;
    case POS_PRE:
    case POS_SUC:
    {
      int c;
      c = anthy_wtype_get_cos(e->dic_ents[i]->type);
      if (c == COS_JN) {
	e->flags |= SF_JN;
      }else if (c == COS_NN) {
	e->flags |= SF_NUM;
      }
    }
    break;
    }
  }
}

/*
 * Ŀͼñɤ߹
 */
static void
add_word_to_private_dic(ddic_t d)
{
  int nr, i;
  xstr *word,*yomi,*tmp;
  wtype_t wt;
  char *cstr;
  int freq;
  struct seq_ent *se;

  nr = anthy_get_nr_values();
  if (nr < 3) {
    return ;
  }
  yomi = anthy_get_index_xstr();
  for (i = 0; i + 2 < nr; i += 3) {
    word = anthy_get_nth_xstr(i);/* ñ */
    tmp = anthy_get_nth_xstr(i+1);/* ʻ̾ */
    cstr = anthy_xstr_to_cstr(tmp);
    anthy_type_to_wtype(cstr, &wt);
    free(cstr);
    freq = anthy_get_nth_value(i+2);/*  */

    se = anthy_ddic_alloc_seq_ent_by_xstr(d, yomi);
    anthy_ddic_push_back_dic_ent(se, word, wt, freq, 0);
  }
}

static void
init_private_dic(struct dic_cache *c)
{
  if (c->priv) {
    anthy_release_ddic(c->priv);
  }
  c->priv = anthy_create_ddic();
  if (anthy_select_section("PRIVATEDIC", 0) == -1) {
    return ;
  }
  if (anthy_select_first_column() == -1) {
    return ;
  }
  do {
    add_word_to_private_dic(c->priv);
  } while (anthy_select_next_column() != -1);
}

int
anthy_init_dic_cache(void)
{
  const char *fn;
  fn = anthy_conf_get_str("SDIC");
  if (!fn) {
    anthy_log(0, "sdic file not specified.\n");
    return -1;
  }
  g_dic_cache.dic = anthy_create_sdic(fn);
  if (!g_dic_cache.dic) {
    anthy_log(0, "Failed to create sdic.\n");
    return -1;
  }
  g_dic_cache.cache = anthy_create_ddic();
  return 0;
}

static struct seq_ent *
cache_get_seq_ent_to_ddic(ddic_t d, xstr *x)
{
  struct seq_ent *s = anthy_ddic_find_seq_ent_by_xstr(d, x);
  if (s) {
    return s;
  }
  s = anthy_ddic_alloc_seq_ent_by_xstr(d, x);

  /* sdicΥեå */
  /* ޤեå */
  anthy_sdic_fill_seq_ent_by_xstr(g_dic_cache.dic, x, s, 0,
				  CC_NONE, CT_NONE, CST_NONE);
  /* ư̾ȤƤθ */
  anthy_sdic_fill_seq_ent_by_xstr(g_dic_cache.dic, x, s, 0,
				  CC_AJV, CT_NONE, CST_NONE);
  /* Ĥ˳Ѥ륨ȥ򸡺 */
  fill_conjugated_ent(x, s);

  /*٤Ƥdic_entФflag׻*/
  calc_seq_flags(s);
  
  return s;
}

static struct seq_ent *
global_cache_get_seq_ent(xstr *x)
{
  return cache_get_seq_ent_to_ddic(g_dic_cache.cache,x);
}

struct seq_ent *
anthy_cache_get_seq_ent(xstr *x)
{
  struct seq_ent *s, *t;
  ddic_t dic;

  if (!anthy_get_current_session_mask()) {
    /*
     * ѡʥƥꤵƤʤΤǡ
     * Х륭å˼Ф
     */
    return global_cache_get_seq_ent(x);
  }

  /* ߥѡʥƥΥåϤ */
  dic = anthy_current_dic->cache;

  /* åˤФ֤ */
  s = anthy_ddic_find_seq_ent_by_xstr(dic, x);
  if (s) {
    return s;
  }

  /*
   * ʬ(ȥѡʥƥ)Υå̵Τ
   * Х륭å򸫤
   */
  t = anthy_ddic_find_seq_ent_by_xstr(g_dic_cache.cache, x);
  if (t) {
    /* äΤƤ򥳥ԡƤ */
    int i;
    s = anthy_ddic_alloc_seq_ent_by_xstr(dic, x);
    s->node_type = t->node_type;
    /* tƤs˥ԡ */
    for (i = 0; i < t->nr_dic_ents; i++) {
      anthy_ddic_push_back_dic_ent(s,
				   &t->dic_ents[i]->str,t->dic_ents[i]->type,
				   t->dic_ents[i]->freq, 0);
    }
    calc_seq_flags(s);
  }else{
    /* ʤäΤǼʬѤ˥쥯Ȥ˼Ф */
    s = cache_get_seq_ent_to_ddic(dic, x);
  }

  /* Ŀͼ񤫤Υեå */
  t = anthy_ddic_find_seq_ent_by_xstr(anthy_current_dic->priv, x);
  if (t) {
    int i;
    /* Ŀͼˤ⤢ä */
    for (i = 0; i < t->nr_dic_ents; i++) {
      anthy_ddic_push_back_dic_ent(s,
				   &t->dic_ents[i]->str,t->dic_ents[i]->type,
				   t->dic_ents[i]->freq, 0);
    }
  }

  if (s->nr_dic_ents == 0) {
    /* ̵ʥȥΤcache */
    anthy_ddic_release_seq_ent(dic, x);
    return 0;
  }
  
  return s;
}

void
anthy_shrink_cache(void)
{
  anthy_shrink_ddic(anthy_current_dic->cache);
}

struct dic_cache *
anthy_create_dic_cache(const char *id)
{
  struct dic_cache *d = malloc(sizeof(struct dic_cache));
  d->id = id;
  d->cache = anthy_create_ddic();
  d->priv = 0;
  init_private_dic(d);
  return d;
}

void
anthy_release_dic_cache(struct dic_cache * d)
{
  anthy_release_ddic(d->cache);
  anthy_release_ddic(d->priv);
  free(d);
}
