#ifndef _dic_main_h_included_
#define _dic_main_h_included_

#include "xstr.h"
#include "wtype.h"

typedef struct ddic_handle *ddic_t;
typedef struct sdic_handle *sdic_t;


/* ٤Ф٤Ψ */
#define FREQ_RATIO 4


/* dic_session.h */
void anthy_init_sessions(ddic_t d);
struct dic_session *anthy_create_session(void);
void anthy_activate_session(struct dic_session *);
void anthy_release_session(struct dic_session *);
int anthy_get_current_session_mask(void);


/* ddic.c */
void anthy_init_ddic(void);
void anthy_quit_ddic(void);
ddic_t anthy_create_ddic(void);
void anthy_release_ddic(ddic_t );
/* node ʤк */
struct seq_ent *anthy_ddic_alloc_seq_ent_by_xstr(ddic_t d,xstr *);
/* node ʤкʤ */
struct seq_ent *anthy_ddic_find_seq_ent_by_xstr(ddic_t d,xstr *);
void anthy_ddic_push_back_dic_ent(struct seq_ent *,xstr *,wtype_t ,
				  int freq, int id);
void anthy_ddic_release_seq_ent(ddic_t d,xstr *);
void anthy_shrink_ddic(ddic_t d);


/* dic_cache.c */
int anthy_init_dic_cache(void);
struct seq_ent *anthy_cache_get_seq_ent(xstr *x);
void anthy_shrink_cache(void);


/* sdic.c */
void anthy_init_sdic(void);
sdic_t anthy_create_sdic(const char *fn);
void anthy_release_sdic(sdic_t );
void anthy_sdic_fill_seq_ent_by_xstr(sdic_t, xstr *, struct seq_ent *,
				     xstr *eow, int cc,
				     int ct, int cst);


/* wtype.c */
void anthy_init_wtypes(void);


/* xchar.c */
void anthy_init_xchar_tab(void);

#endif
