/*
 * Comments in this program are written in Japanese,
 * because this program is a Japanese input method.
 * (many Japanese gramatical terms will appear.)
 *
 * Kana-Kanji conversion engine Anthy.
 * ̾Ѵ󥸥Anthy(󥷡)
 *
 * Funded by IPA̤Ƨեȥ¤ 2001 9/22
 * Copyright (C) 2000-2003 TABATA Yusuke, UGAWA Tomoharu
 * Copyright (C) 2001-2002 TAKAI Kosuke, Nobuoka Takahiro
 * Copyright (C) 2000-2003 KMC(Kyoto University Micro Computer Club)
 *
 * $Id: main.c,v 1.26 2002/11/16 03:35:21 yusuke Exp $
 *
 * The source is covered by the GNU GPL.
 */
/*
 * AnthyѴǽϥ饤֥ȤƹƤꡢ
 * Υեˤϥ饤֥󶡤ؿ(API)ҤƤ롣
 *
 * Ǥϥ饤֥㴳̩˥顼å
 *
 * 󥿡ե˴ؤƤ doc/LIB򻲾ȤƤ
 * AnthyΥɤ򤷤褦Ȥ
 * doc/GLOSSARY Ѹİ뤳Ȥ򴫤ޤ
 */
#include <string.h>
#include <stdlib.h>
#include <stdio.h>

#include <dic.h>
#include <splitter.h>
#include <conf.h>
#include <ordering.h>
#include <logger.h>
#include <record.h>
#include <anthy.h>
#include "main.h"
#include <config.h>

/** AnthyνλɤΥե饰 */
static int is_init_ok;

/** (API) Τν */
int
anthy_init(void)
{
  if (is_init_ok) {
    /* 2ٽʤ褦 */
    return 0;
  }

  /* ƥݡͥȤ˽ */
  if (anthy_init_dic()) {
    anthy_log(0, "Failed to open dictionary.\n");
    return -1;
  }

  if (anthy_init_splitter()) {
    anthy_log(0, "Failed to init splitter.\n");
    return -1;
  }
  anthy_init_contexts();
  anthy_init_personality();

  is_init_ok = 1;
  return 0;
}

/** (API) ǡβ */
void
anthy_quit(void)
{
  if (!is_init_ok) {
    return ;
  }
  anthy_quit_contexts();
  anthy_quit_personality();
  anthy_quit_splitter();
  /* ¿Υǡ¤ϤallocatorˤäƲ */
  anthy_quit_dic();
  is_init_ok = 0;
}

/** (API) ܤξ */
void
anthy_conf_override(const char *var, const char *val)
{
  anthy_do_conf_override(var, val);
}

/** (API) personality */
int
anthy_set_personality(const char *id)
{
  return anthy_do_set_personality(id);
}

/** (API) Ѵcontextκ */
struct anthy_context *
anthy_create_context(void)
{
  if (!is_init_ok) {
    return 0;
  }
  return anthy_do_create_context();
}

/** (API) ѴcontextΥꥻå */
void
anthy_reset_context(struct anthy_context *ac)
{
  anthy_do_reset_context(ac);
}

/** (API) Ѵcontextβ */
void
anthy_release_context(struct anthy_context *ac)
{
  anthy_do_release_context(ac);
}

/** (API) Ѵʸ */
int
anthy_set_string(struct anthy_context *ac, char *s)
{
  xstr *x;
  int retval;

  /* Ѵ򳫻Ϥ˸Ŀͼreload */
  anthy_reload_record();

  x = anthy_cstr_to_xstr(s);
  retval = anthy_do_context_set_str(ac, x);
  anthy_free_xstr(x);
  return retval;
}

/** (API) ʸĹѹ */
void
anthy_resize_segment(struct anthy_context *ac, int nth, int resize)
{
  anthy_do_resize_segment(ac, nth, resize);
}

/** (API) Ѵξ֤μ */
int
anthy_get_stat(struct anthy_context *ac, struct anthy_conv_stat *s)
{
  s->nr_segment = ac->seg_list.nr_segments;
  return 0;
}

/** (API) ʸξ֤μ */
int
anthy_get_segment_stat(struct anthy_context *ac, int n,
			   struct anthy_segment_stat *s)
{
  struct seg_ent *se;
  se = anthy_get_nth_segment(&ac->seg_list, n);
  if (se) {
    s->nr_candidate = se->cand_count;
    s->seg_len = se->str.len;
    return 0;
  }
  return -1;
}

/** (API) ʸμ */
int
anthy_get_segment(struct anthy_context *ac, int nth_seg,
		  int nth_cand, char *buf, int buflen)
{
  struct seg_ent *seg;
  char *p;
  int len;

  /* ʸФ */
  if (nth_seg < 0 || nth_seg >= ac->seg_list.nr_segments) {
    return -1;
  }
  seg = anthy_get_nth_segment(&ac->seg_list, nth_seg);

  /* ʸᤫФ */
  if ((nth_cand < 0 || nth_cand >= seg->cand_count) &&
      nth_cand != NTH_UNCONVERTED_CANDIDATE) {
    return -1;
  }
  if (nth_cand == NTH_UNCONVERTED_CANDIDATE) {
    /* Ѵʸ */
    p = anthy_xstr_to_cstr(&seg->str);
  } else {
    p = anthy_xstr_to_cstr(&seg->cands[nth_cand]->str);
  }

  /* Хåե˽񤭹 */
  len = strlen(p);
  if (!buf) {
    free(p);
    return len;
  }
  if (len + 1 > buflen) {
    /* Хåե­ޤ */
    free(p);
    return -1;
  }
  strcpy(buf, p);
  free(p);
  return len;
}

/* ٤Ƥʸ᤬ߥåȤ줿check */
static int
commit_all_segment_p(struct anthy_context *ac)
{
  int i;
  struct seg_ent *se;
  for (i = 0; i < ac->seg_list.nr_segments; i++) {
    se = anthy_get_nth_segment(&ac->seg_list, i);
    if (se->commit < 0) {
      return 0;
    }
  }
  return 1;
}

/** (API) ʸγ */
int
anthy_commit_segment(struct anthy_context *ac, int s, int c)
{
  struct seg_ent *seg;
  if (!ac->str.str) {
    return -1;
  }
  if (s < 0 || s >= ac->seg_list.nr_segments) {
    return -1;
  }
  if (commit_all_segment_p(ac)) {
    /* ǤƤΥȤߥåȤƤ */
    return -1;
  }

  seg = anthy_get_nth_segment(&ac->seg_list, s);
  if (c == NTH_UNCONVERTED_CANDIDATE) {
    /*
     * Ѵʸ󤬥ߥåȤ줿Τǡбֹõ
     */
    int i;
    for (i = 0; i < seg->cand_count; i++) {
      if (!anthy_xstrcmp(&seg->str, &seg->cands[i]->str)) {
	c = i;
      }
    }
  }
  if (c < 0 || c >= seg->cand_count) {
    return -1;
  }
  seg->commit = c;

  if (commit_all_segment_p(ac)) {
    /* ٤ƤΥȤߥåȤ줿 */
    anthy_proc_commit(&ac->seg_list, &ac->split_info);
  }
  return 0;
}

/** (API) */
void
anthy_print_context(struct anthy_context *ac)
{
  anthy_do_print_context(ac);
}

/** (API) Anthy 饤֥ΥСɽʸ֤
 * ͭ饤֥ǤϳѿΥݡȤϹޤʤΤǴؿˤƤ
 */
const char *
anthy_get_version_string (void)
{
#ifdef VERSION
  return VERSION;
#else  /* just in case */
  return "(unknown)";
#endif
}
