#ifdef HAVE_CONFIG_H
# include "config.h"
#endif

#include <ctype.h>
#include "xim.h"
#include "convdisp.h"
#include "converter.h"

#ifndef __GNUC__
# ifdef HAVE_ALLOCA_H
#  include <alloca.h>
# endif
#endif

int jstring_get_ctext_len(jstring_t *s)
{
    jstring_t::iterator i;
    bool jp_mode;
    int len;
    int cur;
    
    jp_mode = false;
    len = 0;

    for (i = s->begin(); i != s->end(); i++) {
	cur = *i;
	if (!(cur & 0xff00)) {
	    // 2byteʸǤϤʤ
	    if (jp_mode) {
		jp_mode = false;
		len += 4;
	    } else {
		len += 1;
	    }
	} else {
	    // 2byteʸ
	    if (jp_mode) {
		len += 2;
	    } else {
		len += 6;
		jp_mode = true;
	    }
	}
    }
    if (jp_mode) {
	len += 3;
    }
    return len;
}

char *jstring_to_ctext(jstring_t *s)
{
    int len;
    char *t;
    
    len = jstring_get_ctext_len(s);
    t = (char *)malloc(len+1);
    t[len] = 0;
    
    jstring_t::iterator i;
    bool jp_mode=false;
    int cur,j=0;
    for (i = s->begin(); i != s->end(); i++) {
	cur = *i;
	if (!(cur & 0xff00)) {
	    // 1byteʸ
	    if (jp_mode) {
		t[j++] = 0x1b;
		t[j++] = 0x28;
		t[j++] = 0x42;
		jp_mode = false;
	    }
	    t[j++] = cur & 0xff;
	} else {
	    if (!jp_mode) {
		jp_mode = true;
		t[j++] = 0x1b;
		t[j++] = 0x24;
		t[j++] = 0x29;
		t[j++] = 0x42;
	    }
	    t[j++] = (cur >> 8)|0x80;
	    t[j++] = (cur & 0xff)|0x80;
	}
    }
    if (jp_mode) {
	t[j++] = 0x1b;
	t[j++] = 0x28;
	t[j++] = 0x42;
    }
    return t;
}

char *jstring_to_str(jstring_t *s)
{
    jstring_t::iterator i;
    int l=0;
    char *c;
    for (i = s->begin(); i!= s->end(); i++) {
        l++;
        if (*i > 256) {
            l ++;
        }
    }
    c = (char *)malloc(l+1);
    c[l] = 0;
    l = 0;
    for (i = s->begin() ; i!= s->end(); i++) {
        if (*i < 256) {
            c[l] = *i;
            l++;
        } else {
            c[l] = ((*i)>>8)|0x80;
            c[l+1] = ((*i)&0xff)|0x80;
            l+=2;
        }
    }
    return c;
}

// XXX ư̤
void ctext_to_jstring(char *c, jstring_t *s)
{
    bool jp_mode = false;
    while (*c) {
        if (jp_mode) {
            if (*c != 0x1b) {
                s->push_back(c[0]*256+c[1]);
            } else {
                jp_mode = false;
                c++;c++;c++;
            }
        } else {
            if (*c != 0x1b) {
                s->push_back(*c);
                c++;
            } else {
                jp_mode = true;
                c++;c++;c++;
            }
        }
    }
}

void print_jstring(jstring_t *s)
{
    jstring_t::iterator i;
    printf("length=%d : ", s->size());
    int ch;
    char buf[3];
    for (i = s->begin(); i != s->end(); i++) {
        ch = *i;
	buf[1]=0;
	buf[2]=0;
        if (ch < 256) {
	    buf[0]=ch;
        } else {
	    buf[1]=(ch & 255)|0x80;
	    buf[0]=((ch>>8)&255)|0x80;
        }
	printf(buf);
    }
    printf("\n");
}

void erase_jstring(jstring_t *s)
{
    s->erase(s->begin(), s->end());
}

void append_jstring(jstring_t *d, jstring_t *s)
{
    jstring_t::iterator i;
    for (i = s->begin(); i !=s->end(); i++) {
        d->push_back(*i);
    }
}

// EUCJISξб
void str_to_jstring(jstring_t *d, char *s)
{
    int i,len;
    bool inJis= false;
    len = strlen(s);
    for (i = 0; i < len; i++) {
	if (s[i] == 0x1b) {
	    if (s[i+1] == 0x24 && s[i+2]== 0x42) {
		inJis = true;
	    } else if (s[i+1] == 0x28 && s[i+2] == 0x42) {
		inJis = false;
	    }
	    i += 2;
	} else if(inJis || (s[i] & 0x80)) {
	    //2Хʸ
	    cchar ch;
	    ch = ((s[i]&0x7f)<<8)|(s[i+1]&0x7f);
	    i++;
	    d->push_back(ch);
	} else {
	    d->push_back(s[i]);
	}
    }
}
//
KKConv *current_conv;

KKContext *KKConv::createContext(XimIC *xic)
{
    return new KKContext(xic);
}

void init_converter()
{
    current_conv = new KKConv();
}

KKContext *createKKContext(XimIC *ic)
{
    KKContext *c;
    c = NULL;
    if (current_conv) {
	c = current_conv->createContext(ic);
    }
    return c;
}

//
// KKContextΥ᥽å
KKContext::KKContext(XimIC *ic)
{
    m_ic = ic;
    m_pe = new pe_stat(this);
    m_convdisp = 0;
}

KKContext::~KKContext()
{
    if (m_convdisp) {
	m_convdisp->set_pe(0);
    }
    delete m_pe;
}

void KKContext::OnUpdatePe(pe_stat *)
{
}

int KKContext::pushKey(keyState *k)
{
    return COMMIT_RAW;
}

int KKContext::getMode()
{
}

void KKContext::setMode(int mode)
{
}

jstring_t *KKContext::clear()
{
}

void KKContext::update_preedit()
{
    OnUpdatePe(m_pe);
    if (m_convdisp) {
        m_convdisp->update_preedit();
    }
}

void KKContext::set_convdisp(Convdisp *c)
{
    m_convdisp = c;
    if (m_convdisp) {
	m_convdisp->set_pe(m_pe);
    }
}

void KKContext::commit_jstring(jstring_t *s)
{
    m_ic->commit_jstring(s);
}

void KKContext::candidate_selected(int n)
{
}

bool KKContext::extra_input(jstring_t *s)
{
    return false;
}

XimIC *KKContext::get_ic()
{
    return m_ic;
}

keyState::keyState(keyEventX *x)
{
    m_key_code = x->key_sym;
    m_state = x->state;
    m_bPush = x->press;
    m_char_code = conv_keysym_to_charcode(x->key_sym);
}

int keyState::char_code()
{
    return m_char_code;
}

int keyState::key_code()
{
    return m_key_code;
}

bool keyState::is_modifier()
{
    // ugly, but this works
    if (m_key_code >= XK_Shift_L && m_key_code <= XK_Hyper_R) {
	return true;
    }
    return false;
}

int keyState::to_lower()
{
    if (m_char_code < 256) {
	return tolower(m_char_code);
    }
    return m_char_code;
}

bool keyState::modifier(int type)
{
    return type & m_state;
}

bool keyState::is_push()
{
    return m_bPush;
}

void keyState::print()
{
    printf("key code=%x,char_code=%x,modifier=%d.\n",
	   m_key_code, m_char_code,
	   m_state);
}

bool keyState::is_alpha()
{
    return isalpha(m_char_code);
}

int keyState::conv_keysym_to_charcode(int k)
{
    if (k > 127 || k < 32 || (m_state&CTRL_KEY)) {
        return 0;
    }
    return k;
}

char *keyState::modifier_to_str()
{
    static char buf[8];
    int i = 0;
    if (m_state & SHIFT_KEY) {
        buf[i] = 'S';
        i++;
    }
    if (m_state & CTRL_KEY) {
        buf[i] = 'C';
        i++;
    }
    if (m_state & ALT_KEY) {
        buf[i] = 'A';
        i++;
    }
    if (i == 0) {
        return 0;
    }
    buf[i] = 0;
    return buf;
}

Candidates::Candidates()
{
    nth = 0;
    opCount = 0;
}

void Candidates::clear()
{
    nth = 0;
    cands.erase(cands.begin(),cands.end());
}

int Candidates::proc_key(keyState *k,jstring_t *s)
{
    return CAND_NOP;
}
/*
 * Local variables:
 *  c-indent-level: 4
 *  c-basic-offset: 4
 * End:
 */
