#ifdef HAVE_CONFIG_H
#  include <uim/config.h>
#endif

#include <gtk/gtk.h>
#include <stdlib.h>
#include <locale.h>
#include <panel-applet.h>
#include <gnome.h>
#include <libgnome/libgnome.h>
#include <uim/uim.h>
#include <uim/uim-helper.h>

static GtkWidget *tmp_button;
static GList *menu_buttons = NULL;
PanelApplet *uimapplet;
static GtkWidget *hbox;

static int read_tag;
static gchar *result = NULL;
static int uim_fd;

static void 
display_help_dialog (BonoboUIComponent *uic, gpointer data, const gchar *verbname);
static void
display_about_dialog(BonoboUIComponent *uic, gpointer data, const gchar *verbname);

static gboolean
prop_button_pressed(GtkButton *prop_button, GdkEventButton *even, gpointer *user_data);
static void
menu_button_position(GtkMenu *menu, gint *x, gint *y, gboolean *push_in,
		     gpointer *user_data);

static void
activate_event(gpointer callback_data, guint ca, GtkWidget *widget);


static const BonoboUIVerb uim_menu_verbs [] = {
  BONOBO_UI_VERB ("UimHelp",       display_help_dialog),
  BONOBO_UI_VERB ("UimAbout",      display_about_dialog),
  BONOBO_UI_VERB_END
};


static const char uim_menu_xml [] =
        "<popup name=\"button3\">\n"
        "   <menuitem name=\"Help Item\" verb=\"UimHelp\" _label=\"Help\"\n"
        "             pixtype=\"stock\" pixname=\"gtk-help\"/>\n"
        "   <menuitem name=\"About Item\" verb=\"UimAbout\" _label=\"About ...\"\n"
        "             pixtype=\"stock\" pixname=\"gnome-stock-about\"/>\n"
        "</popup>\n";

static gchar *translate(const gchar *path, gpointer data)
{
	return gettext(path);
}

/* Opens gnome help application
 */
static void 
display_help_dialog (BonoboUIComponent *uic, gpointer data, const gchar *verbname)
{
  GError *error = NULL;
  
  gnome_help_display("Uim", NULL, &error);

  if (error)
    {
      GtkWidget *dialog;
      dialog = gtk_message_dialog_new(NULL, 
				      GTK_DIALOG_MODAL | GTK_DIALOG_DESTROY_WITH_PARENT,
				      GTK_MESSAGE_ERROR, GTK_BUTTONS_OK,
				      error->message);
      gtk_dialog_run (GTK_DIALOG (dialog));
      gtk_widget_destroy (dialog);
      g_error_free (error);
      error = NULL;
    }
}

/* Just the about window... If it's already open, just focus it
 */
static void
display_about_dialog(BonoboUIComponent *uic, gpointer data, const gchar *verbname)
{
  /*	GdkPixbuf *icon;*/
  GtkWidget *dialog;
  const char *authors[] = 
    {"Yusuke TABATA <yusuke@cherubim.icw.co.jp> \nTOKUNAGA Hiroyuki <tkng@xem.jp>",NULL};
  
  /* Feel free to put your names here translators */
  char *translators = _("TRANSLATORS");
  
  /* icon = gdk_pixbuf_new_from_xpm_data(ICON_APPLET);*/
  
  dialog = GTK_WIDGET(gnome_about_new (_("Uim Helper Applet"), VERSION, "Copyright 2003 TOKUNAGA Hiroyuki",
				       _("Applet for indicate uim's status"),
				       (const char **) authors, NULL, 
				       strcmp("TRANSLATORS", translators) ? translators : NULL, 
				       NULL));
  
  gtk_widget_show(GTK_WIDGET(dialog));
}

static void
activate_event(gpointer callback_data, guint ca, GtkWidget *widget)
{
  GString *tmp = g_string_new((gchar*)callback_data);
  g_string_prepend(tmp, "prop_activate\n");
  g_string_append(tmp, "\n");
  uim_helper_send_message(uim_fd, tmp->str);
  g_string_free(tmp, TRUE);
}

static void
button_destroy(gpointer data, gpointer user_data)
{
  gtk_widget_destroy(GTK_WIDGET(data));
}

static void
helper_disconnect_cb(void)
{
  gdk_input_remove(read_tag);
}

static void
helper_applet_prop_list_update(gchar **tmp)
{
  GtkItemFactory *mode_item_fact = NULL; /* quiet gcc */
  GtkWidget *button;
  int i = 0;
  gchar **tmp2 = NULL;
  gchar *charset = NULL;
  GString *path = g_string_new("");

  tmp2 = g_strsplit(tmp[1], "=", 0);

  if(tmp2 && tmp2[0] && tmp2[1] && strcmp("charset", tmp2[0]) == 0) {
    charset = strdup(tmp2[1]);
    g_strfreev(tmp2);
  } else {
    g_strfreev(tmp2);
    return;
  }

  if(menu_buttons) {
    g_list_foreach(menu_buttons, button_destroy, NULL);
    g_list_free(menu_buttons);
    menu_buttons = NULL;
  }

  while(tmp[i] && strcmp("", tmp[i]) != 0) {
  
    tmp2 = g_strsplit(tmp[i], "\t", 0);

    if(tmp2 && tmp2[0]) 
      {
	if(strcmp("branch", tmp2[0]) == 0) {
	  
	  if(tmp_button) {
	    gtk_widget_destroy(tmp_button); tmp_button = NULL;
	  }

	  button = gtk_button_new_with_label(tmp2[1]);
	  gtk_box_pack_start(GTK_BOX(hbox), button, FALSE, FALSE, 0);
	  menu_buttons = g_list_append(menu_buttons, button);
	  
	  mode_item_fact = gtk_item_factory_new(GTK_TYPE_MENU, "<main>", NULL);
	  
	  g_signal_connect(G_OBJECT(button), "button_press_event",
			   G_CALLBACK(prop_button_pressed), mode_item_fact);
	  
	  gtk_item_factory_set_translate_func(mode_item_fact, translate, NULL, NULL);
	  gtk_widget_show(button);
	} else if(strcmp("leaf", tmp2[0]) == 0) {
	  g_string_printf(path, "/%s", tmp2[2]);
	  GtkItemFactoryEntry entry = {path->str, NULL, G_CALLBACK(activate_event), 0, ""};
	  gtk_item_factory_create_item ( mode_item_fact, &entry, tmp2[4], 1);

	}
      }
    i++;
  }
}


static void
helper_applet_prop_label_update(gchar **tmp)
{
  GtkWidget *button;
  int i = 0;
  gchar **tmp2 = NULL;
  gchar *charset = NULL;

  if(tmp && tmp[1] ) {
    tmp2 = g_strsplit(tmp[1], "=", 0);
  } else {
    return;
  }

  if(tmp2 && tmp2[0] && tmp2[1] && strcmp("charset", tmp2[0]) == 0) {
    charset = strdup(tmp2[1]);
    g_strfreev(tmp2);
  } else {
    g_strfreev(tmp2);
    return;
  }

  while(tmp[i] && strcmp("", tmp[i]) != 0) {
    i++;
  }

  if(!menu_buttons || i - 2 != g_list_length(menu_buttons)) {
    uim_helper_client_get_prop_list();
    return;
  }
  
  i = 1;

  while(tmp[i] && strcmp("", tmp[i]) != 0) {
    tmp2 = g_strsplit(tmp[i], "\t", 0);
    
    if(tmp2 && tmp2[0] && tmp2[1])
      {
	button = g_list_nth_data(menu_buttons, i - 2 );
	gtk_button_set_label(button, tmp2[0]);
	g_strfreev(tmp2);
      }
    i++;
  }
}


static void
helper_applet_parse_helper_str(char *str)
{
  gchar **tmp, **tmp2; /* think out better name!! */
  int i = 0;
  tmp = g_strsplit(str, "\n\n", 0);

  while(tmp[i]) {
    
    tmp2 = g_strsplit(tmp[i], "\n", 0);
    
    if(tmp2 && tmp2[0]) {
      if( strcmp("prop_list_update", tmp2[0]) == 0) {
       	helper_applet_prop_list_update(tmp2);
      } else if( strcmp("prop_label_update", tmp2[0]) == 0) {
	helper_applet_prop_label_update(tmp2);
      }
      g_strfreev(tmp2);
    }
    i++;
  }
  g_strfreev(tmp);
 
}

static void
uim_applet_fd_cb(gpointer p, gint fd, GdkInputCondition c)
{
  static char buf[1024];
  int i,rc;

  if(!result)
    result = strdup("");

  while((i = uim_helpler_fd_readable(fd)) > 0) {

    rc = read(fd, buf, sizeof(buf)-1);
    
    if(rc == 0) {
      gdk_input_remove(fd);
      return;
    }
    buf[rc] = '\0';
    result = (char*)realloc(result, strlen(result) + strlen(buf)+1);
   
  strcat(result, buf);
  }
  
  if(uim_helper_str_terminated(result)) {
    helper_applet_parse_helper_str(result);
    free(result);
    result = NULL;
  }
  

  free(result);
}

static GtkWidget * init_toolbar(void)
{
  hbox = gtk_hbox_new(FALSE, 0);

  uim_helper_client_get_prop_list();

  tmp_button = gtk_button_new_with_label("?");
  gtk_button_set_relief(GTK_BUTTON(tmp_button), GTK_RELIEF_HALF);

  g_signal_connect(G_OBJECT(tmp_button), "button_press_event",
		   G_CALLBACK(prop_button_pressed), NULL);
  
  gtk_box_pack_start(GTK_BOX(hbox), tmp_button, FALSE, FALSE, 0);

  return hbox; 
}



static gboolean
prop_button_pressed(GtkButton *prop_button, GdkEventButton *event,
		    gpointer *user_data)
{
  int x,y;

  if(!event) {
    return FALSE;
  } else if(event->button == 2 || event->button == 3) {
    gtk_propagate_event(GTK_WIDGET(uimapplet), (GdkEvent *) event);
    return FALSE;
  }

  if(!user_data)
    return FALSE;

  menu_button_position(NULL,&x,&y,NULL, prop_button);
  gtk_item_factory_popup(user_data, x, y, NULL, NULL);
  return TRUE;
}

static void
menu_button_position(GtkMenu *menu, gint *x, gint *y, gboolean *push_in,
			  gpointer *user_data)
{
        GtkWidget *widget;
        gint wheight;
        gint wx, wy;

	g_return_if_fail(x && y);
 	g_return_if_fail(GTK_IS_BUTTON(user_data));

	widget = GTK_WIDGET(user_data);

	gdk_window_get_origin(widget->window, x, y);

        wheight = widget->requisition.height;
	wx = widget->allocation.x;
        wy = widget->allocation.y;
         
        *y = *y + wy + wheight;
        *x = *x + wx;
}

static gboolean
uim_applet_new(PanelApplet *applet,
		 const gchar *iid,
		 gpointer     data)
{
  GtkWidget *toolbar;
  uimapplet = applet;
 
  if (strcmp (iid, "OAFIID:GNOME_UimApplet") != 0)
    return FALSE;
  
  uim_fd     = uim_helper_init_client_fd(helper_disconnect_cb);
  
  toolbar = init_toolbar();
 
  if(uim_fd > 0)
    read_tag = gdk_input_add(uim_fd, (GdkInputCondition)GDK_INPUT_READ,
			     uim_applet_fd_cb, 0);

  gtk_container_add (GTK_CONTAINER (applet), toolbar);  
  gtk_widget_show_all (GTK_WIDGET (applet));

  panel_applet_setup_menu(applet,
			  uim_menu_xml,
			  uim_menu_verbs,
			  toolbar);

  return TRUE;
}



PANEL_APPLET_BONOBO_FACTORY ("OAFIID:GNOME_UimApplet_Factory",
                             PANEL_TYPE_APPLET,
                             "uim gnome2 Applet",
                             "0",
                             (PanelAppletFactoryCallback)uim_applet_new,
                             NULL);
