;;TODO
;;    ::ñϿ
;;
;;⡼ɰ
;;  ܸϥ⡼(ܸϥ⡼ɤɬס)
;;  ѿ⡼
;;  ѱѿ⡼
;;  
;;ơȰ
;;  *ܸϥ⡼
;;    Ե,Ͼ,Ѵ
;;  *ñϿ⡼
;;    ɤϾ,ñϾ
;;

(require "japanese.scm")
(require "generic-key.scm")


;; configs
(define prime-use-candidate-window? #t)
(define prime-candidate-op-count 1) ;;䥦ɥɽޤǤ˲󥹥ڡ򲡤ɬפ뤫
(define prime-preedit-immididate-commit? #f)
(define prime-always-show-window? #t)

;;  (.uimǾ񤭤˻ѤƤޤͽꡣ⤽ޤѤƤʤɡ)
(define PRIME-RAW-INPUT-MODE 0)       ;;PRIME-INPUT-MODE-RAWȤϤɤʡ
(define PRIME-HIRAGANA-INPUT-MODE 1)
(define PRIME-KATAKANA-INPUT-MODE 2)
(define PRIME-WIDE-LATIN-INPUT-MODE 3)
(define PRIME-DEFAULT-INPUT-MODE PRIME-RAW-INPUT-MODE)

;; key
(define prime-latin-key
  (lambda (key key-state)
    (or
     (generic-off-key key key-state)
     (= (to-lower-char key) 108))))
(define prime-wide-latin-key
  (lambda (key key-state)
    (and (= (to-lower-char key) 108)
	 (shift-key-mask key-state))))
(define prime-begin-conv-key
  (lambda (key key-state)
    (= key 32)))
(define prime-on-key
  (lambda (key key-state)
    (or
     (and (= (to-lower-char key) 106)
	  (control-key-mask key-state))
     (generic-on-key key key-state))))
(define prime-commit-key
  (lambda (key key-state)
    (generic-commit-key key key-state)))
(define prime-next-candidate
  (lambda (key key-state)
    (generic-next-candidate-key key key-state)))
(define prime-prev-candidate
  (lambda (key key-state)
    (or
     (generic-prev-candidate-key key key-state)
     (= (to-lower-char key) 120))))

(define prime-kana-toggle
  (lambda (key key-state)
    (= (to-lower-char key) 113)))
(define prime-cancel-key
  (lambda (key key-state)
    (generic-cancel-key key key-state)))

(define prime-backspace-key
  (lambda (key key-state)
    (generic-backspace-key key key-state)))

(define prime-delete-key
  (lambda (key key-state)
    (generic-delete-key key key-state)))

(define prime-go-left-key
  (lambda (key key-state)
    (generic-go-left-key key key-state)))

(define prime-go-right-key
  (lambda (key key-state)
    (generic-go-right-key key key-state)))

;; access
(define prime-context-immediate-commit ;;Ūprime-preedit-immididate-commit?򥪥դˤ뤫ɤ
 (lambda (ac)
   (car (nthcdr 15 ac))))

(define prime-context-set-immediate-commit!
  (lambda (ac mode)
    (set-car! (nthcdr 15 ac) mode)))

(define prime-context-last-word ;;PRIMEPOBoxѸǤContext
 (lambda (ac)
   (car (nthcdr 14 ac))))

(define prime-context-set-last-word!
  (lambda (ac mode)
    (set-car! (nthcdr 14 ac) mode)))

(define prime-context-mode
 (lambda (ac)
   (car (nthcdr 13 ac))))

(define prime-context-set-mode!
  (lambda (ac mode)
    (set-car! (nthcdr 13 ac) mode)))

(define prime-context-left-string ;;κ¦ˤpreeditʸΥꥹ
 (lambda (ac)
   (car (nthcdr 12 ac))))

(define prime-context-set-left-string!
  (lambda (ac str)
    (set-car! (nthcdr 12 ac) str)))

(define prime-context-right-string
 (lambda (ac)
   (car (nthcdr 11 ac))))

(define prime-context-set-right-string!
  (lambda (ac str)
    (set-car! (nthcdr 11 ac) str)))

(define prime-context-candidates
  (lambda (c)
   (car (nthcdr 10 c))))

(define prime-context-set-candidates!
  (lambda (c cnt)
    (set-car! (nthcdr 10 c) cnt)))

(define prime-context-candidate-window
  (lambda (c)
   (car (nthcdr 9 c))))

(define prime-context-set-candidate-window!
  (lambda (c cnt)
    (set-car! (nthcdr 9 c) cnt)))

(define prime-context-candidate-op-count
  (lambda (c)
   (car (nthcdr 8 c))))
    
(define prime-context-set-candidate-op-count!
  (lambda (c cnt)
    (set-car! (nthcdr 8 c) cnt)))

(define prime-context-rk-context
  (lambda (c)
   (car (nthcdr 7 c))))

(define prime-context-set-rk-context!
  (lambda (c rkc)
    (set-car! (nthcdr 7 c) rkc)))

(define prime-context-nth
  (lambda (c)
    (car (nthcdr 6 c))))

(define prime-context-set-nth!
  (lambda (c nth)
    (set-car! (nthcdr 6 c) nth)))

(define prime-context-tail
  (lambda (c)
    (car (nthcdr 4 c))))

(define prime-context-set-tail!
  (lambda (c tail)
    (set-car! (nthcdr 4 c) tail)))

(define prime-context-set-head!
  (lambda (c head)
    (set-car! (nthcdr 2 c) head)))

(define prime-context-head
  (lambda (c)
    (car (nthcdr 2 c))))

(define prime-context-kana-mode
  (lambda (sc)
    (car (nthcdr 1 sc))))

(define prime-context-set-kana-mode!
  (lambda (sc mode)
    (set-car! (nthcdr 1 sc) mode)))

(define prime-context-state
  (lambda (c)
    (car (nthcdr 0 c))))

(define prime-context-set-state!
  (lambda (c s)
    (set-car! (nthcdr 0 c) s)))
;; state kana head okuri tail candidates nth rk

(define prime-flush
  (lambda (sc)
    (rk-flush (prime-context-rk-context sc))
    (prime-context-set-state! sc 'prime-state-no-preedit)
    (prime-context-set-head! sc '())
    (prime-context-set-immediate-commit! sc #t)
    (prime-context-set-tail! sc '())
    (prime-context-set-left-string! sc '())
    (prime-context-set-right-string! sc '())
    (prime-context-set-nth! sc nil)
    (prime-context-set-candidate-window! sc #f)))


(define prime-context-new
  (lambda ()
    (let ((c 
	   (copy-list 
	    '(prime-state-latin #t "" "" "" () () () () () () () () 0 "" #t))))
      (prime-context-set-head! c ())
      (prime-context-set-rk-context! c
				   (rk-context-new ja-rk-rule #t #f))
      (prime-flush c)
      (prime-context-set-state! c 'prime-state-latin)
      c)))

(define prime-make-string
  (lambda (sc sl dir)  ;;dirʸɽ(걦¦ʸϸդˤʤäƤ)
    (let ((kana?))
      (if (= 1 (prime-context-mode sc))
	  (set! kana? #t))
      (if (= 2 (prime-context-mode sc))
	  (set! kana? #f))
      (if sl
	  (if dir
	      (string-append (prime-make-string sc (cdr sl) dir)
			     (if kana?
				 (caar sl)
				 (cdar sl)))
	      (string-append (if kana?
				 (caar sl)
				 (cdar sl))
			     (prime-make-string sc (cdr sl) dir)))
	  ""))))

(define prime-context-kana-toggle
  (lambda (sc)
    (let ((s (prime-context-kana-mode sc)))
      (set! s (not s))
      (if s
	  (prime-context-set-mode! sc 1)
	  (prime-context-set-mode! sc 2))
      (prime-context-set-kana-mode! sc s))))

(define prime-get-string-by-mode
  (lambda (sc res)
    (if res
	(if (prime-context-kana-mode sc)
	    (car res)
	    (cdr res))
	nil)))

(define prime-get-nth-candidate
  (lambda (sc n)
    (if (> n (prime-get-nr-candidates sc))
	nil)
    (car (cdr (car (nthcdr n (prime-context-candidates sc)))))
    ))

(define prime-get-nr-candidates
  (lambda (sc)
    (length (prime-context-candidates sc))))

(define prime-get-current-candidate
  (lambda (sc)
    (prime-get-nth-candidate
     sc
     (prime-context-nth sc))))

(define prime-get-candidates! ;;⤦äȴؿ̾ɤˤ
  (lambda (sc preedit context)
	(let ((tmp))
	  (prime-lib-send-command (string-append "set_context\t"  context "\n"))
	  (prime-context-set-candidates!
	   sc
	   (prime-parse-cands
		(prime-lib-send-command (string-append "l\t"  preedit "\n"))))
	  )))

(define prime-make-assoc-list
  (lambda (lst)
	(mapcar 
	 (lambda (str)
	   (string-split str "="))
	 lst)))

(define prime-commit-candidate
  (lambda (sc)
	(let ((nth (prime-context-nth sc)))
	  (set! assoc-list 
			(prime-make-assoc-list 
			 (cddar (nthcdr nth (prime-context-candidates sc)))))
	  (prime-learn-word sc assoc-list)
	  )))

(define prime-learn-word
  (lambda (sc assoc-list)
    (let ((key     (or (cadr (assoc "basekey"     assoc-list)) ""))
	  (value   (or (cadr (assoc "base"        assoc-list)) ""))
	  (part    (or (cadr (assoc "part"        assoc-list)) ""))
	  (context (or (prime-context-last-word sc) ""))
	  (suffix  (or (cadr (assoc "conjugation" assoc-list)) ""))
	  (rest    (or (cadr (assoc "suffix"      assoc-list)) "")))

	  (prime-lib-send-command
	   (string-append "learn_word\t" key "\t" value "\t" part "\t" context "\t" suffix "\t" rest "\n"))

	  (prime-context-set-last-word!
	   sc
	   (prime-get-current-candidate sc))
	  )))

(define prime-parse-cands
  (lambda (cands-string)
	(mapcar
	 (lambda (str-line)
	   (string-split str-line "\t"))
	 (cdr (delq "" (string-split cands-string "\n"))))))

(define prime-begin-conversion
  (lambda (sc id)
    (let ((res))
	  (prime-get-candidates!
	   sc 
	   (prime-make-string sc (prime-context-left-string sc) #t)
	   (prime-context-last-word sc))
      (set! res
	    (prime-get-nth-candidate sc 0))
      (if res
	  (begin
	    (prime-context-set-nth! sc 0)
	    (prime-context-set-state!
	     sc 'prime-state-converting))
	  (prime-flush sc))
      ())))

(define prime-update-preedit
  (lambda (id sc)
    (let ((rkc (prime-context-rk-context sc))
	  (stat (prime-context-state sc)))
      (im-clear-preedit id)
      (if (= stat 'prime-state-converting)
	  (begin
	    (im-pushback-preedit
	     id preedit-reverse
	     (prime-get-current-candidate sc)))
	  (if (prime-has-preedit? sc)
	      (let ((hl (prime-make-string
			 sc (prime-context-left-string sc) #t))
		    (hr (prime-make-string
			 sc (prime-context-right-string sc) #f)))
		(if (string? hl)
		    (im-pushback-preedit
		     id preedit-underline
		     hl))
		(im-pushback-preedit id preedit-underline
				     (rk-pending rkc))
		(im-pushback-preedit id preedit-cursor "")
		(if (string? hr)
		    (im-pushback-preedit
		     id preedit-underline
		     hr)))))
      (im-update-preedit id))))

(define prime-update-mode
  (lambda (id sc)
    (let ((mode (prime-context-mode sc)))
      (im-update-mode id mode))))

(define prime-update-candidate-window
  (lambda (sc id)
    (if (and
	 (prime-has-preedit? sc)
	 (not (prime-context-candidate-window sc))
	 (or prime-always-show-window?
	     (> (prime-context-candidate-op-count sc)
		prime-candidate-op-count)))
	(begin
	  (prime-get-candidates!
	   sc
	   (prime-make-string sc (prime-context-left-string sc) #t)
	   (prime-context-last-word sc))
	  (im-begin-candidate
	   id (prime-get-nr-candidates sc) 0)
	  (prime-context-set-candidate-window! sc #t)
	  ))
    (if (not (prime-has-preedit? sc))
	(begin
	  (prime-context-set-candidate-window! sc #f)
	  (im-end-candidate id)))
    (if (prime-context-candidate-window sc)
	(begin
	  (prime-get-candidates!
	   sc
	   (prime-make-string sc (prime-context-left-string sc) #t)
	   (prime-context-last-word sc))	  
	  (im-update-candidate id (prime-context-nth sc))))
    ))

(define prime-has-preedit?
  (lambda (ac)
    (or
     (> (length (prime-context-left-string ac)) 0)
     (> (length (prime-context-right-string ac)) 0)
     (> (length (rk-pending (prime-context-rk-context ac))) 0))))

(define prime-proc-input-no-preedit
  (lambda (c key key-state)
    (let* ((sc (context-data c))
	   (id (context-id c))
	   (key-str (charcode->string (to-lower-char key)))
	   (rkc (prime-context-rk-context sc))
	   (res nil)
	   (direct (ja-direct (charcode->string key)))
	   (immediate-commit))
      (and
       (if (prime-wide-latin-key key key-state)
	   (begin
	     (prime-context-set-mode! sc 3)
	     (prime-update-mode id sc)
	     #f)
	   #t)
       (if (prime-latin-key key key-state)
	   (begin
	     (prime-context-set-mode! sc 0)
	     (prime-update-mode id sc)
	     #f)
	   #t)
       (if (prime-cancel-key key key-state)
	   (begin
	     (prime-flush sc)
	     #f)
	   #t)
       (if (prime-kana-toggle key key-state)
	   (begin 
	     (prime-context-kana-toggle sc)
	     (prime-update-mode id sc)
	     #f)
	   #t)
       (if (prime-backspace-key key key-state)
	   (if (not (rk-backspace rkc))
	       (begin
		 (im-commit-raw (context-id c))
		 #f)
	       #f)
	   #t)
       (if (control-key-mask key-state)
	   (begin
	     (im-commit-raw id)
	     #f)
	   #t)
       (if (and
	    (shift-key-mask key-state)
	    (alphabet-char? key))
	   (begin
	     (prime-context-set-immediate-commit! sc #f)
	     #t)
	   #t)
       ;; direct key => commit
       (if direct
	   (begin
	     (im-commit id direct)
	     #f)
	   #t)
       (if (symbol? key)
	   (begin
	     (prime-flush sc)
	     (prime-context-set-last-word! sc "")
	     (im-commit-raw (context-id c))
	     #f)
	   #t)
       (prime-proc-input-with-preedit c key key-state))
      nil)))

(define prime-proc-input-with-preedit
  (lambda (c key key-state)
    (let* ((sc (context-data c))
	   (id (context-id c))
	   (rkc (prime-context-rk-context sc))
	   (stat (prime-context-state sc))
	   (res))
      (and
       (if (prime-begin-conv-key key key-state)
	   (begin
	     (prime-begin-conversion sc id)
	     #f)
	   #t)
       (if (prime-cancel-key key key-state)
	   (begin
	     (prime-flush sc)
	     #f)
	   #t)
       (if (prime-backspace-key key key-state)
	   (begin
	     (if (not (rk-backspace rkc))
		 (if (prime-has-preedit? sc)
		     (prime-context-set-left-string!
		      sc (cdr (prime-context-left-string sc)))
		     (begin
		       (im-commit-raw id)
		       (prime-flush sc))))
	     #f)
	   #t)
       ;; delete
       (if (prime-delete-key key key-state)
	   (begin
	     (if (not (rk-delete rkc))
		 (if (prime-context-right-string sc)
		     (prime-context-set-right-string!
		      sc
		      (cdr (prime-context-right-string sc)))))
	     #f)
	   #t)
       ;;
       (if (prime-commit-key key key-state)
	   (begin
	     (im-commit id (prime-make-string
			    sc (prime-context-left-string sc) (prime-context-kana-mode sc)))
	     (prime-flush sc)
	     (prime-update-mode id sc)
	     #f)
	   #t)
       ;; left
       (if (prime-go-left-key key key-state)
	   (begin
	     (if (prime-context-left-string sc)
		 (let ((c (car (prime-context-left-string sc))))
		   (prime-context-set-left-string!
		    sc (cdr (prime-context-left-string sc)))
		   (prime-context-set-right-string! 
		    sc
		    (cons c (prime-context-right-string sc)))))
	     #f)
	   #t)
       ;; right
       (if (prime-go-right-key key key-state)
	   (begin
	     (if (prime-context-right-string sc)
		 (let ((c (car (prime-context-right-string sc))))
		   (prime-context-set-right-string!
		    sc (cdr (prime-context-right-string sc)))
		   (prime-context-set-left-string!
		    sc
		    (cons c (prime-context-left-string sc)))))
	     #f)
	   #t)
       (if (numeral? key)
	   (begin
	     (prime-context-set-nth! sc (- key 49))
	     (im-commit id (prime-get-nth-candidate sc (- key 49)))
	     (prime-commit-candidate sc)
	     (prime-flush sc)
	     (prime-update-mode id sc)
	     #f)
	   #t)
       ;; modifiers (shift) => ignore
       (if (and (modifier-key-mask key-state) (not (shift-key-mask key-state)))
	   (begin
	     (im-commit-raw id)
	     #f)
	   #t)
       (begin
	 (set! res
	       (rk-push-key!
		rkc
		(charcode->string (to-lower-char key))))
	 (if res
	     (begin
	       (prime-context-set-left-string!
		sc
		(cons res
		      (prime-context-left-string sc)))
	       (prime-context-set-candidate-window! sc #f) ;FIXME:very duty hack
	       (if (and prime-preedit-immididate-commit? (prime-context-immediate-commit sc))
		   (begin 
		     (im-commit id (prime-make-string sc (prime-context-left-string sc) #t))
		     (prime-flush sc)
		     #f)
		   #t)
	       ))))
      nil)))

(define prime-proc-state-converting
  (lambda (c key key-state)
    (let ((sc (context-data c))
	  (id (context-id c))
	  (res ()))
      (and
       (if (prime-next-candidate key key-state)
	   (begin
	     (prime-context-set-nth! sc
				     (+ 1 (prime-context-nth sc)))
	     (if (not (prime-get-current-candidate
		       sc (prime-context-nth sc)))
	     (prime-context-set-nth! sc 0))
	     (prime-context-set-candidate-op-count!
	      sc
	      (+ 1 (prime-context-candidate-op-count sc)))
	     #f)
	   #t)
       (if (prime-prev-candidate key key-state)
	   (begin
	     (if (> (prime-context-nth sc) 0)
		 (prime-context-set-nth! sc (- (prime-context-nth sc) 1))
		 (prime-context-set-nth! sc (- (prime-get-nr-candidates sc) 1)))
	     #f)
	   #t)
       (if (prime-cancel-key key key-state)
	   (begin
	     (prime-flush sc)
	     #f)
	   #t)
       (if (prime-commit-key key key-state)
	   (begin
	     (set! res (prime-get-current-candidate sc))
	     (prime-commit-candidate sc)
	     (prime-flush sc)
	     (prime-update-mode id sc)
	     #f)
	   #t)
       (begin
	 (prime-update-mode id sc)
	 (set! res (prime-get-current-candidate sc))
	 (prime-commit-candidate sc)
	 (prime-flush sc)
	 (let ((res2 (prime-proc-input-no-preedit c key key-state)))
	   (set!
	    res
	    (string-append
	     res 
	     (prime-make-string sc
				(prime-context-tail sc)
				(prime-context-kana-mode sc))))
	   (if (string? res2)
	       (set! res
		     (string-append res res2))))))
      res)))

(define prime-proc-mode-latin
  (lambda (c key key-state)
    (let ((sc (context-data c))
	  (id (context-id c)))
      (if
       (prime-on-key key key-state)
       (begin
	 (prime-context-set-mode! sc 1)
	 (prime-update-mode id sc))
       (im-commit-raw id))
      ())))

(define prime-proc-mode-wide-latin
  (lambda (c key key-state)
    (let* ((w (ja-wide (charcode->string key)))
	   (id (context-id c))
	   (sc (context-data c)))
      (if (prime-on-key key key-state)
	  (begin
	    (prime-flush sc)
	    (prime-context-set-mode! sc 1)
	    (prime-update-mode id sc))
	  (if w
	      (im-commit id w)
	      (im-commit-raw id)))
      ())))

(define prime-push-key
  (lambda (c key key-state)
    (let* ((sc (context-data c))
	   (state (prime-context-state sc))
	   (mode (prime-context-mode sc))
	   (fun)
	   (res))
      (if (= mode 0)
	  (set! fun prime-proc-mode-latin))
      (if (= mode 3)
	  (set! fun prime-proc-mode-wide-latin))
      (if (or (= mode 1) (= mode 2))
	  (begin
	    (if (prime-has-preedit? sc)
		(set! fun prime-proc-input-with-preedit)
		(set! fun prime-proc-input-no-preedit))
	    (if (= state 'prime-state-converting)
		(set! fun prime-proc-state-converting))))
      (set! res (fun c key key-state))  
      (if res
	  (im-commit (context-id c) res))
      (prime-update-preedit (context-id c) sc)
      (prime-update-candidate-window sc (context-id c))
      )))

(define prime-init-handler
  (lambda (id arg)
    (let* ((c (find-context id)))
      (set-context-data! c
			 (prime-context-new))
      (im-clear-mode-list id)
      (im-pushback-mode-list id "RAW")
      (im-pushback-mode-list id "Ҥ餬")
      (im-pushback-mode-list id "")
      (im-pushback-mode-list id "ѱѿ")
      (im-update-mode-list id)
      (im-update-mode id 0))))

(define prime-press-key-handler
  (lambda (id key state)
    (let* ((c (find-context id)))
      (prime-push-key c key state))))

(define prime-release-key-handler
  (lambda (id key state)
    ()))

(define prime-reset-handler
  (lambda (id)
    ()))

(define prime-mode-handler
  (lambda (id mode)
    (let* ((c (find-context id))
	   (sc (context-data c)))
      (prime-flush sc)
      (prime-context-set-mode! sc mode)
      (if (= mode 1)
	  (prime-context-set-kana-mode! sc #t))
      (if (= mode 2)
	  (prime-context-set-kana-mode! sc #f))
      (prime-update-preedit id sc)
      ())))

(define prime-get-candidate-handler
  (lambda (id idx)
    (let* ((c (find-context id))
	   (sc (context-data c)))
      (prime-get-nth-candidate sc idx))))

(define prime-set-candidate-index-handler
  (lambda (id idx)
    (let* ((c (find-context id))
	   (sc (context-data c)))
      (prime-context-set-nth! sc idx)
      (prime-update-preedit  id sc))))

(register-im
 'prime
 "ja"
 "EUC-JP"
 nil
 prime-init-handler
 nil
 prime-mode-handler
 prime-press-key-handler
 prime-release-key-handler
 prime-reset-handler
 prime-get-candidate-handler
 prime-set-candidate-index-handler
 nil)
