#ifndef _context_h_included_
#define _context_h_included_

#include <iconv.h>

#include "uim.h"
#include "siod.h"

struct uim_im {
  char *lang;
  char *name;
  char *encoding;
};

struct cb_q {
  struct cb *first_cb;
  struct cb *tail_cb;
  int flushing;
};

struct uim_context_ {
  void *ptr;
  /* internal id */
  int id;
  /* global id for helper */
  int global_id;

  iconv_t conv;
  char *encoding;
  /**/
  int commit_raw_flag;
  /**/
  int nr_modes;
  char **modes;
  /**/
  int mode;
  /**/
  char *proplabelstr;
  char *propstr;
  /**/
  int candidate_index;
  int nr_candidates;
  /**/
  void (*commit_cb)(void *ptr, char *str);
  /* preedit */
  void (*preedit_clear_cb)(void *ptr);
  void (*preedit_pushback_cb)(void *ptr, int attr, char *str);
  void (*preedit_update_cb)(void *ptr);
  /* mode list */
  void (*mode_list_update_cb)(void *ptr);
  /* mode */
  void (*mode_update_cb)(void *ptr, int);
  /* property list */
  void (*prop_list_update_cb)(void *ptr, char *str);
  /* property label */
  void (*prop_label_update_cb)(void *ptr, char *str);
  /* candidate window */
  void (*candidate_begin_cb)(void *ptr, int nr, int index);
  void (*candidate_update_cb)(void *ptr, int index);
  void (*candidate_end_cb)(void *ptr);
  /**/
  struct cb_q cb_q;
};

#define CAND_BEGIN_CB 1
#define CAND_UPDATE_CB 2
#define CAND_END_CB 3
#define COMMIT_CB 4
#define PREEDIT_CLEAR_CB 5
#define PREEDIT_PUSHBACK_CB 6
#define PREEDIT_UPDATE_CB 7
#define MODE_UPDATE_CB 8
#define MODE_LIST_UPDATE_CB 9
#define PROP_LABEL_UPDATE_CB 10
#define PROP_LIST_UPDATE_CB 11

struct cb {
  int type;
  char *str;
  int n1, n2;
  struct cb *next;
};

/**/
uim_context
uim_find_context(int id);
void uim_init_util_subrs();
void uim_init_im_subrs();

char *uim_get_c_string(LISP str);
int uim_key_sym_to_int(LISP sym);
char *uim_code_conv(char *str, iconv_t ic);

void uim_eval_string(uim_context, char *str);
void uim_schedule_cb(uim_context, int type, char *str, int n1, int n2);

extern struct uim_im *uim_im_array;
extern int uim_nr_im;

#endif
