#include <signal.h>
#include <stdlib.h>
#include <sys/types.h>
#include <unistd.h>
#include <fcntl.h>
#include <errno.h>

#include "context.h"

static FILE *primer = NULL, *primew = NULL;
static int prime_pid = 0;

extern LISP sym_t;

static char *prime_command = "prime";

static LISP
prime_send_command(LISP str_)
{
  char *str = get_c_string( str_ );
  char *result;
  LISP ret;

  result = uim_ipc_send_command(&prime_pid, &primer, &primew, prime_command, str);

  if(result == NULL)
    {
      return NIL;
    }

 ret = strcons( strlen(result), result );
 free(result);
 return ret;

}

static LISP
prime_lib_init(void)
{
  prime_pid = uim_ipc_open_command(prime_pid, &primer, &primew, prime_command );
  if(prime_pid == 0) {
    return NIL;
  }
  return sym_t;
}

void
uim_init_prime(void)
{
  init_subr_0("prime-lib-init", prime_lib_init);
  init_subr_1("prime-lib-send-command", prime_send_command);
}
