#include <unistd.h>
#include <sys/socket.h>
#include <sys/types.h>
#include <sys/time.h>
#include <sys/un.h>
#include <netinet/in.h>
#include <netdb.h>
#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <pwd.h>
#include <errno.h>
#include <uim/context.h>

enum RorW
  {
    READ,
    WRITE,
  };

char*
uim_helper_send_message(int fd, char *message)
{
  static char buf[1024];
  char *result = NULL;
  FILE *rfile, *wfile;
  int i, rc;

  if(fd < 0)
    return "";

  if(!message)
    return "";

  /* readable and cannot read any character, means disconnected.
     so we should read here and proc such condition. */

  //  rfile = fdopen(fd, "r");
  wfile = fdopen(fd, "w");
  
  fputs(message, wfile);
  fputs("\n",wfile);
  fflush(wfile);
  /*  printf("send massage:%s",message);*/
  return "";

}

char *
uim_helper_get_pathname(void)
{
  char *path;
  char *login;
 
  login = getenv("LOGNAME");
  
  if(!login) {
    struct passwd *pw;
    pw = getpwuid(getuid());
    login = strdup(pw->pw_name);
    free(pw);
  }

  path = (char*)malloc(strlen(login)+ 20);
  sprintf(path, "/tmp/uimhelper-%s",login);
  return path;
}


static int
uim_helper_fd(int fd, enum RorW rw)
{
    int rc;
    fd_set fds;
    struct timeval tv;

    /*   if(!fd || fd < 0)
	 return -1;*/

    FD_ZERO(&fds);
    FD_SET(fd, &fds);
    tv.tv_sec = tv.tv_usec = 0;

    if(rw == READ)
      rc = select(fd+1, &fds, NULL, NULL, &tv);
    else    
      rc = select(fd+1, NULL, &fds, NULL, &tv);

    if (rc < 0)
      return -1;
    
    return FD_ISSET(fd,&fds) ? 1 : 0;
}

int uim_helpler_fd_readable(int fd)
{
  return uim_helper_fd(fd, READ);
}

int uim_helpler_fd_writable(int fd)
{
  return uim_helper_fd(fd, WRITE);
}


int uim_helper_str_terminated(char *str)
{
  if(!str)
    return 0;

  if(strlen(str) > 2&&
     str[strlen(str)-1] == '\n' &&
     str[strlen(str)-2] == '\n' )
    return 1;

  return 0;
}
