;; SKKκƵؽ򥤥饤ǹԤδʰץƥȥǥ
;;
(define skk-editor-new
  (lambda (sc id)
    (let ((ec (copy-list '(() () () ()))))
      (skk-editor-set-context! ec sc)
      (skk-editor-set-id! ec id)
      ec)))

(define skk-editor-context
  (lambda (ec)
    (car (nthcdr 0 ec))))

(define skk-editor-set-context!
  (lambda (ec s)
    (set-car! (nthcdr 0 ec) s)))

(define skk-editor-id
  (lambda (ec)
    (car (nthcdr 1 ec))))

(define skk-editor-set-id!
  (lambda (ec s)
    (set-car! (nthcdr 1 ec) s)))

(define skk-editor-left-string
  (lambda (ec)
    (car (nthcdr 2 ec))))

(define skk-editor-set-left-string!
  (lambda (ec s)
    (set-car! (nthcdr 2 ec) s)))

(define skk-editor-right-string
  (lambda (ec)
    (car (nthcdr 3 ec))))

(define skk-editor-set-right-string!
  (lambda (ec s)
    (set-car! (nthcdr 3 ec) s)))

(define skk-editor-flush
  (lambda (ec)
    (skk-editor-set-left-string! ec '())
    (skk-editor-set-right-string! ec '())))

(define skk-editor-make-string
  (lambda (sl dir)
    (if sl
	(if dir
	    (string-append (skk-editor-make-string (cdr sl) dir)
			   (car sl))
	    (string-append (car sl)
			   (skk-editor-make-string (cdr sl) dir)))
	"")))

(define skk-editor-get-left-string
  (lambda (ec)
    (skk-editor-make-string
     (skk-editor-left-string ec) #t)))

(define skk-editor-get-right-string
  (lambda (ec)
    (skk-editor-make-string
     (skk-editor-right-string ec) #f)))

(define skk-editor-commit-char-list
  (lambda (ec sl)
    (if sl
	(begin
	  (skk-editor-set-left-string!
	   ec
	   (cons (car sl)
		 (skk-editor-left-string ec)))
	  (skk-editor-commit-char-list
	   ec (cdr sl))))))

(define skk-editor-commit
  (lambda (ec str)
    (skk-editor-commit-char-list
     ec (reverse (skk-lib-split-string str)))))
				 
(define skk-editor-commit-raw
  (lambda (ec key key-state)
    (let ((raw-str (im-get-raw-key-str key key-state))
	  (sc (skk-editor-context ec))
	  (str
	   (string-append
	    (skk-editor-get-left-string ec)
	    (skk-editor-get-right-string ec))))
      (if raw-str
	  (skk-editor-commit ec raw-str)
	  (and
	   (if (skk-backspace-key key key-state)
	       (let ((cur (skk-editor-left-string ec)))
		 (if cur
		     (skk-editor-set-left-string!
		      ec (cdr cur)))
		 #f)
	       #t)
	   (if (= key 'return)
	       (begin
		 (skk-lib-learn-word
		  (skk-make-string (skk-context-head sc) #t)
		  (skk-context-okuri-head sc)
		  (skk-make-string (skk-context-okuri sc) #t)
		  str)
		 (skk-commit-editor-context
		  sc (skk-editor-id ec) str)
		 #f)
	       #t))))))
