/**/
#ifdef HAVE_CANNA_JRKANJI_H
#include <canna/RK.h>
#include <stdlib.h>
#include <dlfcn.h>
#include "context.h"

#define MAX_SIZE 256

extern LISP sym_t;

static struct canna_context {
  int used;
  char workbuf[MAX_SIZE];
  int rk_context_id;
} *context_array;
static int context_array_len;

static struct canna_api {
  /*  struct rkfuncs Rk; */
  int (*RkInitialize)(char *);
  int (*RkCreateContext)(void);
  int (*RkCloseContext)(int);
  int (*RkBgnBun)(int, char *, int, int);
} api;

static int
get_canna_api(void)
{
  void *lib;

  lib = dlopen("libcanna.so.1", RTLD_NOW);
  if(!lib) {
    return -1;
  }
  api.RkInitialize = dlsym(lib, "RkInitialize");
  api.RkCreateContext = dlsym(lib, "RkCreateContext");
  api.RkCloseContext = dlsym(lib, "RkCloseContext");
  api.RkBgnBun = dlsym(lib, "RkBgnBun");
  if(api.RkInitialize && api.RkCreateContext &&
     api.RkCloseContext && api.RkBgnBun) {
    /* ok! */
    return 0;
  }
  return -1;
}

static LISP
init_canna_lib()
{
  if (get_canna_api() == -1) {
    return NIL;
  }
  if (api.RkInitialize(NULL)) {
    return NIL;
  }
  return NIL;
  /* not yet*/
  return sym_t;
}

static int
find_id()
{
  int i;
  for (i = 0; i < context_array_len; i++) {
    if (!context_array[i].used) {
      context_array[i].used = 1;
      return i;
    }
  }
  context_array = realloc(context_array,
			  sizeof(struct canna_context) * i);
  context_array[i].used = 1;
  return i;
}

static LISP
alloc_id()
{
  int id = find_id();
  struct canna_context *cc = &context_array[id];
  cc->rk_context_id = api.RkCreateContext();
  return flocons(id);
}

static LISP
release_id(LISP id_)
{
  int id = get_c_long(id_);
  struct canna_context *cc = &context_array[id];
  cc->used = 0;
  api.RkCloseContext(cc->rk_context_id);
  return NIL;
}

static LISP
set_string(LISP id_, LISP str_)
{
  return NIL;
}

static LISP
get_preedit(LISP id_)
{
  return NIL;
}


void
uim_init_canna()
{
  init_subr_0("canna-lib-init", init_canna_lib);

  init_subr_0("canna-lib-alloc-id", alloc_id);
  init_subr_1("canna-lib-release-id", release_id);
  init_subr_2("canna-lib-set-string", set_string);
  init_subr_1("canna-lib-get-preedit", get_preedit);
}
#endif
