// IIIMP Υͥ
#include <sys/types.h>
#include <sys/socket.h>
#include <unistd.h>
#include <stdio.h>
#include "packet.h"
#include "impn.h"
#include "imconn.h"
#include "imic.h"

IMConn::IMConn(int fd)
{
  mFd = fd;
  mStat = PRE_CONNECT;
}

IMConn::~IMConn()
{
  std::map<int,IMIC *>::iterator it;
  for ( it = mICs.begin() ; it != mICs.end() ; it++ ){
    delete (*it).second;
  }
  std::list<TxPacket *>::iterator jt;
  for ( jt = mTxQ.begin() ; jt != mTxQ.end() ; jt++){
    delete *jt;
  }
}

int IMConn::getFd()
{
  return mFd;
}

bool IMConn::isWritePending()
{
  if ( mTxQ.size()){
    return true;
  }
  return false;
}

void IMConn::read_proc()
{
  switch(mStat){
  case PRE_CONNECT:
    proc_initial_packet();
    break;
  case OK:
    proc_packet();
    break;
  case CLOSE_WAIT:
  case INVALID:;
  }
}

void IMConn::write_proc()
{
  std::list<TxPacket *>::iterator i;
  void *buf = 0;
  for ( i = mTxQ.begin() ; i != mTxQ.end() ;){
    int len = (*i)->get_length();
    buf = realloc(buf,len);
    (*i)->write_to_buf((unsigned char*)buf,len,endian);
    send(mFd,buf,len,0);
    if ( iiim_trace_flag ){
        (*i)->dump(endian);
    }
    delete *i;
    i = mTxQ.erase(i);
  }
  free(buf);
  //check
  if (mTxQ.size() == 0 && mStat == CLOSE_WAIT ){
    close(mFd);
    mStat = INVALID;
  }
}

bool IMConn::isValid()
{
  if ( mStat == INVALID ){
    return false;
  }
  return true;
}

void IMConn::proc_initial_packet()
{
  /*ǤꤦѥåȤIM_CONNECTΤ*/
  unsigned char buf[9];
  int len;
  len = recv(mFd,buf,9,MSG_PEEK);
  if ( len <= 0){
    /*ͥڤȤ褦Ǥ*/
    mStat = INVALID;
    if ( len == -1 ){
      perror("recv");
      goto invalid;
    }
    printf("Connection fail.");
    return ;
  }
  int off;
  if ( len >= 5){
    if ( buf[0] == IM_CONNECT){
      off = 4;
    }else if (buf[0] == (IM_CONNECT | 0x80 )){
      if ( len < 9 ){
	return ;
      }
      off = 9;
    }else{
      goto invalid;
    }
  }else{
    return ;
  }
  if ( buf[off] == 0x6c ){
    /*LSB first Υѥå*/
    endian = LSB_FIRST;
  }else if ( buf[off] == 0x42 ){
    /*MSB first Υѥå*/
    endian = MSB_FIRST;
  }else{
    // invalid
    printf("Invaid packet.\n");
    goto invalid;
  }
  /*ޤǤǥǥϷ*/
  mStat = OK;
  proc_packet();
  return;
 invalid:
  mStat = INVALID;
  close(mFd);
}

void IMConn::proc_packet()
{
  unsigned char buf[9];
  int len;
  len = recv(mFd,buf,9,MSG_PEEK);
  if ( len <= 0){
    /*ͥڤȤ褦Ǥ*/
    mStat = INVALID;
    if ( len == -1 ){
      perror("recv");
      close(mFd);
    }
    if ( trace_flag ){
      printf("Invalid connection.\n");
    }
    return ;
  }
  len = RxPacket::get_len(buf,len,endian);
  if ( len == 0 ){
    // إåޤǤƤʤ
      printf("Incomplete header\n");
    return ;
  }
  if ( len == -1 ){
    // إå˥顼롣
    printf("error in header\n");
    mStat = INVALID;
    close(mFd);
    return ;
  }
  RxPacket *p;
  void *buf2= malloc(len);
  if ( len == recv(mFd,buf2,len,MSG_PEEK)){
    recv(mFd,buf2,len,0);
    p = createRxPacket(buf2,len,endian);
    dispatch_packet(p);
    return ;
  }else{
    free(buf2);
  }
}

void IMConn::pushTxPacket(TxPacket *t)
{
  mTxQ.push_back(t);
}

void IMConn::dispatch_packet(RxPacket *p)
{
  if (iiim_trace_flag) {
    p->dump();
  }
  switch(p->getOpCode()){
  case IM_CONNECT:
    proc_im_connect(p);
    break;
  case IM_DISCONNECT:
    proc_im_disconnect(p);
    break;
  case IM_SETIMVALUES:
    proc_im_set_im_values(p);
    break;
  case IM_CREATEIC:
    proc_im_create_ic(p);
    break;
  case IM_DESTROYIC:
    proc_im_destroy_ic(p);
    break;
  case IM_RESETIC:
    proc_im_reset_ic(p);
    break;
  case IM_TRIGGER_NOTIFY:
    proc_im_trigger_notify(p);
    break;
  case IM_FORWARD_EVENT:
    proc_im_forward_event(p);
    break;
  case IM_PREEDIT_START_REPLY:
    proc_preedit_start_reply(p);
    break;
  case IM_PREEDIT_DRAW_REPLY:
    proc_preedit_draw_reply(p);
    break;
  case IM_PREEDIT_DONE_REPLY:
    proc_preedit_done_reply(p);
    break;
  case IM_STATUS_START_REPLY:
    proc_status_start_reply(p);
    break;
  case IM_STATUS_DRAW_REPLY:
    proc_status_draw_reply(p);
    break;
  case IM_STATUS_DONE_REPLY:
    proc_status_done_reply(p);
    break;
  default:
    printf("Unknown or Unimplemented type of packet.\n");
    break;
  }
}

void IMConn::proc_im_connect(RxPacket *p)
{
  C8 endian = p->getC8();
  C8 version = p->getC8();
  STRING user_name = p->getSTRING();
  C16 auth_proto_name_len = p->getC16();
  int i;
  for ( i = 0 ; i < auth_proto_name_len * 4 ; ){
    STRING auth_proto = p->getSTRING();
    i += getSTRINGlen(&auth_proto);
  }

  TxPacket *t = createTxPacket(IM_REGISTER_TRIGGER_KEYS);
  t->pushC16(1);
  t->pushC16(0);//pad
  // 0 on-keys
  t->pushC32(0);
  // 0 off-keys
  t->pushC32(0);
  pushTxPacket(t);

  t = createTxPacket(IM_CONNECT_REPLY);
  t->pushC16(1);// input method id
  STRING lang_name = createSTRING("ja");
  int len = getSTRINGlen(&lang_name)/4;
  t->pushC16(len);
  t->pushSTRING(lang_name);
  pushTxPacket(t);
}

void IMConn::proc_im_disconnect(RxPacket *p)
{
  TxPacket *t = createTxPacket(IM_DISCONNECT_REPLY);
  t->pushC16(1);
  t->pushC16(0);
  pushTxPacket(t);
  mStat = CLOSE_WAIT;
}

void IMConn::proc_im_set_im_values(RxPacket *p)
{
  int i,len,imid= p->getC16();
  p->getC16();//unused
  /*
  len = p->getC32();
  for  ( i = 0 ; i < len ; ){
      int atr_id,atr_len,j;
      atr_id = p->getC16();
      p->getC16();
      atr_len = p->getC16();
      for ( j = 0 ; j < atr_len ; j++){
	p->getC8();
      }
      for ( j = 0 ; j < pad4(atr_len) ; j++){
          p->getC8();
      }
  }
  */

  TxPacket *t = createTxPacket(IM_SETIMVALUES_REPLY);
  t->pushC16(1);
  t->pushC16(0);
  pushTxPacket(t);
}

void IMConn::proc_im_create_ic(RxPacket *p)
{
  int imid,icid;
  int len;
  IMIC *ic;
  icid = get_unused_ic_id();
  ic = new IMIC(this,1,icid);
  mICs.insert(std::pair<int,IMIC*>(icid,ic));
  imid = p->getC16();
  len = p->getC16();

  TxPacket *t = createTxPacket(IM_CREATEIC_REPLY);
  t->pushC16(imid);
  t->pushC16(icid);
  pushTxPacket(t);
}

void IMConn::proc_im_destroy_ic(RxPacket *p)
{
  int imid,icid;
  imid = p->getC16();
  icid = p->getC16();
  std::map<int,IMIC *>::iterator it;
  it = mICs.find(icid);
  if ( it != mICs.end() ){
    delete (*it).second;
    mICs.erase(it);
  }
}

void IMConn::proc_im_reset_ic(RxPacket *p)
{
  int imid,icid;
  imid = p->getC16();
  icid = p->getC16();
  TxPacket *t;
  t = createTxPacket(IM_RESETIC_REPLY);
  t->pushC16(imid);
  t->pushC16(icid);
  pushTxPacket(t);
}

void IMConn::proc_im_trigger_notify(RxPacket *p)
{
  int imid,icid,flag;
  imid = p->getC16();
  icid = p->getC16();
  flag = p->getC16();

  IMIC *ic = get_ic_by_id(icid);
  ic->trigger_notify((bool)(flag == 0));

  TxPacket *t = createTxPacket(IM_TRIGGER_NOTIFY_REPLY);
  t->pushC16(imid);
  t->pushC16(icid);
  pushTxPacket(t);
}

void IMConn::proc_im_forward_event(RxPacket *p)
{
  int imid,icid;
  imid = p->getC16();
  icid = p->getC16();
  IMIC *ic = get_ic_by_id(icid);
  keyEvent ev;
  p->getC32();
  p->getC32();
  ev.keycode = p->getC32();
  ev.keychar = p->getC32();
  ev.modifier = p->getC32();
  ev.timestamp = p->getC32();

  TxPacket *t = createTxPacket(IM_COMMIT_STRING);
  t->pushC16(imid);
  t->pushC16(icid);
  t->pushC32(0);// STRING
  char buf[3];
  printf("(%d)",ev.keychar);
  buf[0] = ev.keychar;
  buf[1] = 0;
  STRING str = createSTRING(buf);
  t->pushSTRING(str);
  pushTxPacket(t);

  t = createTxPacket(IM_FORWARD_EVENT_REPLY);
  t->pushC16(imid);
  t->pushC16(icid);
  pushTxPacket(t);
}

void IMConn::proc_preedit_start_reply(RxPacket *p)
{
  int imid,icid;
  imid = p->getC16();
  icid = p->getC16();
  IMIC *ic = get_ic_by_id(icid);
  ic->preedit_draw(p->getC32());
}

void IMConn::proc_preedit_draw_reply(RxPacket *p)
{
  int imid,icid;
  imid = p->getC16();
  icid = p->getC16();
  IMIC *ic = get_ic_by_id(icid);
  ic->preedit_done();
}

void IMConn::proc_preedit_done_reply(RxPacket *p)
{
  // Do nothing.
}

void IMConn::proc_status_start_reply(RxPacket *p)
{
  int imid,icid;
  imid = p->getC16();
  icid = p->getC16();
  IMIC *ic = get_ic_by_id(icid);
  ic->status_draw();
}

void IMConn::proc_status_draw_reply(RxPacket *p)
{
  int imid,icid;
  imid = p->getC16();
  icid = p->getC16();
  IMIC *ic = get_ic_by_id(icid);
  ic->status_done();
}

void IMConn::proc_status_done_reply(RxPacket *p)
{
  // Do nothing.
}

int IMConn::get_unused_ic_id()
{
  int i;
  for ( i = 1; ; i++){
    if (! get_ic_by_id(i) ){
      return i;
    }
  }
  //never reach here
  return 0;
}

IMIC *IMConn::get_ic_by_id(int id)
{
  std::map<int,IMIC *>::iterator it;
  it = mICs.find(id);
  if ( it == mICs.end()){
    return 0;
  }
  return (*it).second;
}
