// -*- C++ -*-
#ifndef _imic_h_included_
#define _imic_h_included_

class IMConn;
class RxPacket;
class TxPacket;
struct preedit;
 
// key modifier mask
#define MOD_NONE 0
#define MOD_SHIFT 1
#define MOD_CTRL 2
 
struct keyEvent{
  int keycode,keychar,modifier,timestamp;
  void print();
};

class IMIC{
public:
  IMIC(IMConn *conn,int imid,int icid);
  void forward_event(RxPacket *p);
  void trigger_notify(bool );
  void preedit_draw(int );
  void preedit_done();
  void status_draw();
  void status_done();
private:
  void composePreedit(TxPacket *);
  void update_status();
  int mICid,mIMid;
  IMConn *mConn;
  int mPrevPeLen;
  bool mIsActive;

  void proc_key_event(RxPacket *p);
};

#endif
