<?php
/**
 * Enter description here...
 *
 * @package aowp.parser.ast
 */

/**
 * PHPIfStatementElement
 *
 * PHPのASTにおける「if」を表すクラス
 * 文法規則: unticked_statement
 *
 * @package aowp.parser.ast
 * @access  public
 * @author  Ryoto Naruse <naruse@minnie.ai.kyutech.ac.jp>
 *
 */
class AOWP_PHPIfStatementElement extends AOWP_PHPElement implements AOWP_ITagStatementElement {
	/**
	 * {@link AOWP_PHPObjectOperatorElement}等 (要調査)。
	 * 
	 * @var AOWP_PHPElement
	 */
	public $condition;
	/**
	 * 
	 * @var AOWP_PHPInnerStatementElement
	 */
	public $innerStatements;
	/**
	 * 
	 * @var AOWP_PHPElseIfStatementElement
	 */
	public $elseifStatements;
	/**
	 * {@link AOWP_PHPInnerStatementElement}の配列。
	 * elseが有る時は、必ず長さ1の配列?
	 * 配列である必要は、ないのでは?
	 * 
	 * @var array
	 */
	public $elseStatements;
	
	public function __construct($_line = null, $condition = null, $innerStatements = null, $elseifStatements = null, $elseStatements = null) {
		$this->condition 		= $condition;
		$this->innerStatements 	= $innerStatements;
		$this->elseifStatements = $elseifStatements;
		$this->elseStatements 	= $elseStatements;
		$this->initialize($_line);
	}
	
	public function setCondition(AOWP_PHPElement $condition) {
		$this->condition = $condition;
	}
	
	/**
	 * $elementは、PHPの文章となりうる、Statement系のASTインスタンス。
	 * 
	 * @param $element
	 * @return void
	 */
	public function addStatement(AOWP_PHPElement $element) {
		if (!isset($this->innerStatements) || !($this->innerStatements instanceof AOWP_PHPInnerStatementElement)) {
			$this->innerStatements = new AOWP_PHPInnerStatementElement();
		}
		$this->innerStatements->setElement($element);
	}
	
	public function addElseStatement(AOWP_PHPElement $element) {
		if (!isset($this->elseStatements[0]) || !($this->elseStatements[0] instanceof AOWP_PHPInnerStatementElement)) {
			$this->elseStatements = array(new AOWP_PHPInnerStatementElement());
		}
		$this->elseStatements[0]->setElement($element);
	}
	
	public function __toString() {
		return "";
	}
	
	public function kind() {
		return 'if';
	}
}
?>