<?php
/**
 * 
 * @author keiji
 *
 */
/**
 * 
 * @author keiji
 *
 */
class ALP_DefLocMapGenerator {
	public static function generateDefLocMap($targetLocation = null) {
		$targetLocation = $targetLocation === null ?
			ALP_Configuration::PROJECT_LOCATION :
			$targetLocation;
//		echo "\n" . 'Target folder (' . $targetLocation . ').' . "\n";
		if (file_exists($targetLocation) && is_dir($targetLocation)) {
			$defLocMap = new ALP_ClassDefLocMap(true);
			$directory = dir($targetLocation);
			while (($fileName = $directory->read()) !== false) {
				$filePath = $targetLocation . DIRECTORY_SEPARATOR . $fileName;
//				echo 'Target file (' . $filePath . ').' . "\n";
				if ($fileName == '.' || $fileName == '..' || (strpos($fileName, '.bk') !== false)) {
//					echo 'Skip (' . $fileName . ')' . "\n";
				}
				else if ($fileName != '.svn' && is_dir($filePath)) {
					$subDefLocMap = ALP_DefLocMapGenerator::generateDefLocMap($filePath);
					$defLocMap->merge($subDefLocMap);
				}
				else if (preg_match('/\.php$/', $fileName) &&
						($classNameArray = ALP_Configuration::getClassNames($fileName, $targetLocation)) !== null) {
					foreach ($classNameArray as $className) {
						echo 'Add class definition location (' . $className . '> ' . $filePath  . ')' . "\n";
						$defLocMap->addClassDefLoc($className, $filePath);
					}
				}
			}
			return $defLocMap;
		}
		else {
			return null;
		}
	}
}
?>