<?php
/**
 * 長い説明文
 * 
 * @package aowp.aspect.pointcut.designators
 */
/**
 * 指定した条件式を満たすとき、全てのジョインポイントを選択するポイントカット記述子です。
 * 
 * @package aowp.aspect.pointcut.designators
 */
class AOWP_IfPointcut extends AOWP_Pointcut {
	/**
	 * 
	 * @var string
	 */
	private $_condition;
	
	/**
	 * 引き数の条件式は、PHPの条件文を表す文字列です。
	 * この条件式は、実行時に{@link eval()}関数で評価されます。
	 * 
	 * @param string $condition 条件式を表す文字列
	 */
	public function __construct($condition) {
		$this->_condition = $condition;
	}
	
	protected function _isJoinPointShadow(AOWP_JoinPoint $joinPoint) {
		return true;
	}
	
	protected function _runtimeMatch(AOWP_JoinPoint $joinPoint) {
		return eval('return ' . $this->_condition . ';');
	}
	
}
?>