<?php
/**
 * 
 * @package aowp.aspect.joinpoint
 */
/**
 * 
 * @author keiji
 * @package aowp.aspect.joinpoint
 *
 */
abstract class AOWP_JoinPointWithArguments extends AOWP_JoinPoint {
	
	private $_argumentArray;
	private $_staticArgumentCount;
	
	public function __construct(AOWP_PHPElement $element = null, $fileName = null) {
		parent::__construct($element, $fileName);
		$this->_argumentArray = array();
	}
	
	public function addArgument($argument) {
		$this->_argumentArray[] = $argument;
	}
	public function setArgument($argument, $index) {
		$this->_argumentArray[$index] = $argument;
	}
	public function getArgumentArray() {
		return $this->_argumentArray;
	}
	public function getArgument($argumentIndex) {
		return isset($this->_argumentArray[$argumentIndex]) ? $this->_argumentArray[$argumentIndex] : null;
	}
	
	/**
	 * 
	 * @param int $staticArgumentCount
	 * @return void
	 */
	public function setStaticArgumentCount($staticArgumentCount) {
		$this->_staticArgumentCount = $staticArgumentCount;
	}
	/**
	 * 
	 * @return int
	 */
	public function getStaticArgumentCount() {
		return $this->_staticArgumentCount;
	}
	
}
?>