<?php
/**
 * Advice.class
 *
 * @package aowp.aspect.advice
 */
abstract class AOWP_Advice {

	private $_pointcut;
	private $_type;
	private $_index;
	private $_adviceBodyFunctionName;
	private $_adviceBodyInstance;
	private $_classNameOfAspect;
	private $_aspect;
	
	public function setPointcut(AOWP_Pointcut $pointcut) {
		$this->_pointcut = clone $pointcut;
		$this->_pointcut->setAdvice($this);
	}
	
	public function getPointcut() {
		return $this->_pointcut;
	}
	
	public function isHavePointcut(AOWP_Pointcut $pointcut) {
		return $this->_pointcut->isHavePointcut($pointcut);
	}
	
	public function setAspect(AOWP_Aspect $aspect) {
		$this->_aspect = $aspect;
	}
	
	public function getAspect() {
		return $this->_aspect;
	}
	
	public function getClassNameOfAspect() {
		return get_class($this->_aspect);
	}
	
	public function setIndex($index) {
		$this->_index = $index;
	}
	
	public function getIndex() {
		return $this->_index;
	}
	
	/**
	 * @param String $functionName
	 * @param datatype paramname description
	 */
	public function setAdviceBody($functionName, $instance = null) {
		$this->_adviceBodyFunctionName = $functionName;
		$this->_adviceBodyInstance = $instance; // Is this operation needed?
	}
	
	public function getAdviceBodyFunctionName() {
		return $this->_adviceBodyFunctionName;
	}
	
	public function isJoinPointShadow(AOWP_JoinPoint $joinPoint) {
		return $this->_pointcut !== null ?
			$this->_pointcut->isJoinPointShadow($joinPoint) :
			false;
	}
	
	public function runtimeMatch(AOWP_JoinPoint $joinPoint) {
		return $this->_pointcut !== null ?
			$this->_pointcut->runtimeMatch($joinPoint) :
			false;
	}
	
	public function weave(AOWP_JoinPoint &$joinPoint) {
		$joinPoint->weave($this);
	}
	
	public function getWeavedAST(AOWP_PHPElement $replaceAST = null) {
		return new AOWP_PHPWovenElement($this->_classNameOfAspect, $this->_index, $replaceAST);
	}
}
?>
