<?php
/**
 * 長い説明文
 * 
 * @package aowp.aspect.pointcut.designators
 */
/**
 * メソッド呼び出しのイベントを選択するポイントカット記述子です。
 *
 * @package aowp.aspect.pointcut.designators
 */
class AOWP_MethodCallPointcut extends AOWP_Pointcut {
	private $_className;
	private $_methodName;
	private $_argumentsCount;

	/**
	 * 
	 * @param $className クラス名
	 * @param $methodName メソッド名
	 * @param $argumentsCount 引き数の数
	 */
	public function __construct ($className, $methodName, $argumentsCount = -1) {
		$this->_className = $className;
		$this->_methodName = $methodName;
		$this->_argumentsCount = $argumentsCount;
	}
	
	/**
	 * PHPでは型付けが明示的でないため、実行時にインスタンスの方に関する評価を行っています。
	 * なお、現在は、コンストラクタで指定したクラス名を{@link mb_ereg_match}で、対象のインスタンスと比較しており、
	 * AspectJで指定可能な+を用いたサブクラスとのマッチが行えません。
	 * 
	 * @see aspect/pointcut/AOWP_Pointcut#runtimeMatch()
	 */
	protected function _runtimeMatch(AOWP_JoinPoint $joinPoint) {
		return AOWP_Pointcut::patternMatch($this->_className, get_class($joinPoint->getInvokedObject()));
	}
	
	protected function _isJoinPointShadow(AOWP_JoinPoint $joinPoint) {
		return ($joinPoint instanceof AOWP_MethodCallJoinPoint) &&
			AOWP_Pointcut::patternMatch($this->_methodName, $joinPoint->getMethodName()) &&
			(($this->_argumentsCount === -1) || ($this->_argumentsCount === $joinPoint->getStaticArgumentCount()));
	}
	
}
?>
