<?php
class AccessManager {
	
	private static $_userDB = null;

	public static function auth($name, $password) {
		$user = AccessManager::_getUser($name);
		return $user !== null && $user->authentication($password) ? $user : null;
	}
	
	private static function _getUser($name) {
		AccessManager::_initDB();
		return array_key_exists($name, AccessManager::$_userDB) ? AccessManager::$_userDB[$name] : null;
	}
	
	private static function _initDB() {
		if (AccessManager::$_userDB === null) {
			AccessManager::$_userDB = array(
				'aowp' => new User(4, 'aowp', 'passwd'),
				'keiji' => new User(1, 'keiji', 'passwd'),
				'ryoto' => new User(2, 'ryoto', 'passwd'),
				'masaru' => new User(3, 'masaru', 'passwd')
			);
		}
	}
}
?>
