<?php
class TraceMonitor {

	private $_accessTimeTraces;
	
	public function __construct() {
		$this->_accessTimeTraces = array();
	}
	
	public function checkAccessInterval() {
		if (count($this->_accessTimeTraces) + 1 > TraceMonitorAspect::MONITORED_TRACE_COUNT) {
			array_shift($this->_accessTimeTraces);
		}
		$this->_accessTimeTraces[] = time();
		$traceCount = count($this->_accessTimeTraces);
		if ($traceCount >= TraceMonitorAspect::MONITORED_TRACE_COUNT) {
			$averageIntervalTime = ($this->_accessTimeTraces[$traceCount - 1] - $this->_accessTimeTraces[0]) / ($traceCount - 1);
			return $averageIntervalTime > TraceMonitorAspect::MIN_INTERVAL;
		}
		else {
			return true;
		}
	}
}
?>