/** @file	boot.S
 *  @brief	A 512-byte boot manager.
 *  Copyright (c) kaworu
 *  $Id: boot.S,v 1.1.1.1 2003/10/12 18:01:01 kaworu Exp $
 *  @author	kaworu
 *  @date	since 2003/06/11 update: $Date: 2003/10/12 18:01:01 $
 *  @version	$Revision: 1.1.1.1 $
 */
#include "boot.h"

        .code16gcc		# This runs in real mode
        .text
        .global         _start
        .global		puts
_start:
	#ljmp	$BOOTSEG,	$reentry
        jmp	reentry
	nop
# FAT12 boot parameter block
	.ascii	"artesia "	# OEM Label
	.word	0x0200
	.byte	0x01
	.word	0x001
	.byte	0x02
	.word	0x00e0
	.word	0x0b40
	.byte	0xf0
	.word	0x009
	.word	0x0012
	.word	0x002
#.double	0x00000000
#	.double	0x00000000
#	.word	0x0000, 0x0000
	.word	0x0000, 0x0000

	.word	0x0000
	.byte	0x29
	.double	0x00000000

	.ascii	"NO NAME    "	# Disk Label
	.ascii	"FAT12   "	# FS

reentry:
        cli					# Clear the interrupt flag
	pushl	%ebp
	movl	%esp,		%ebp		# stack

	movw	$BOOTSEG,	%ax
	movw	%ax,		%es		# Address
	movw	%ax,		%ds		# data
	//xorw	%ax,		%ax		# Zero
	movw	%ax,		%ss		# stack

	call	video_init

	# Phase00 message.
	movl	$phase00,	%esi		# phase00 message addr
	call	putx

	call	copy_myself

	/*
	 * :$INITSEGinit_segإפ
	 */
	ljmp	$INITSEG,	$init_seg
init_seg:
	movw	%ax,		%es		# es = ax = INITSEG
	movw	$0x4000-12,	%di		# Ŭʥåΰ
	movw	%ax,		%ds		# as = INITSEG
	movw	%ax,		%ss
	movw	%di,		%sp

	call	fd_init
	call	load_wake			# load wake
	call	load_kernel
	call	fd_close

	ljmp	$WAKESEG,	$0x000		# exec wake
	//	ljmp	$DUMMYSEG,	$0x000		# exec kernel
	# NOTREACHED
loop:
        jmp	loop		# Loop forever


/*
 * ʬȤ 90000Hإԡإפ
 */
copy_myself:
	/*
	 * ds = BOOTSEG;
	 * ax = INITSEG;
	 * es = INITSEG;
	 * cx = 256;
	 * si = 0;
	 * di = 0;
	 */
//	movw	$BOOTSEG,	%ax
//	movw	%ax,		%ds
	movw	$INITSEG,	%ax
	movw	%ax,		%es
	movw	$256,		%cx
	subw	%si,		%si
	subw	%di,		%di
	/*
	 * copy DS:SI to ES:DI
	 * for (cx = 256; cx > 0; cx--)
	 * {
	 * 	DS:SI = ES:DI;
	 *      DI = SI += SI;
	 * }
	 */
	cld				# stringžadoress򾺽
	rep
	movsw				# DS:SI = ES:DI;

	ret

fd_init:
	call	fd_reset
	call	fd_set
	ret

fd_reset:
	// Floppy Disk Init
	movl	$FDRESET,	%esi
	call	putx

	xorw	%ax,		%ax	// ax = 0;
	xorb	%dl,		%dl	// ɥ饤0 (0/1)
	int	$0x13			// When error, CF=1
	jc	hell			// fd_reset false
	// success
	movl	$OK,		%esi
	call	putx
	ret

// ɥ饤֥ѥ᡼
fd_set:
	movw	%cx,		%fs
	movw	$0x0078,	%bx
	pushw	%ds
	ldsw	%fs:(%bx),	%si
	movb	$6,		%cl
	pushw	%di
	rep
	movsw
	popw	%di
	popw	%ds

	// ȥåΥĴ٤
	// Ϥʤ
	// 16ȸʤ
	/*
	 * FD drive parameter table
	 * 04h sectors per track(maximum if different for different tracks)
	 */
	movb	$16,	0x4(%di)
	movw	%di,	%fs:(%bx)	//
	movw	%es,	%fs:(%bx)	//

	ret

// loading wake
	// 0x90200 wakeɤ
load_wake:
	movl	$LOADWAKE,	%esi
	call	putx

	// FD ɤ߹
	movb	$0x02,		%ah	//
	movb	$0x02,		%al	// sector 
	movb	$0x00,		%ch	//  track number
	movb	$0x02,		%cl	// sector
	movb	$0x00,		%dh	// head number
	movb	$0x00,		%dl	// drive number
	movw	$0x0200,	%bx
	int	$0x13
	jc	hell

	addw	$'0',		%ax
	movl	%eax,		%esi
	call	putc

	movl	$msg_sect,	%esi
	call	putx

	movl	$OK,		%esi
	call	putx

	ret

load_kernel:
//	movl	$DUMMYSEG,	%esi
//	call	putx

	// FD ɤ߹
	movb	$0x02,		%ah	//
	movb	$0x08,		%al	// ɤ߹sectorο
	movb	$0x00,		%ch	//  track number
	movb	$0x04,		%cl	// ɤ߹ߤ򳫻Ϥsector
	movb	$0x00,		%dh	// head number
	movb	$0x00,		%dl	// drive number
	movw	$0x0600,	%bx	// ɤ߾address
	int	$0x13
	jc	hell

	addw	$'0',		%ax
	movl	%eax,		%esi
	call	putc

	movl	$msg_sect,	%esi
	call	putx

	movl	$OK,		%esi
	call	putx

	ret

	/*
		movw	$boot_gdt,	%si
		movw	$0x8700,	%ax
		int	$0x15
	 */

/*
 * FDΥ⡼ߤ롣
 */
fd_close:
#if 1
        xorw	%ax,            %ax
        xorb    %dl,            %dl
        int     $0x13
#else
        movw    $0x3f2,         %dx
        xorb    %al,            %al
        outb    %al,            %dx
#endif
	ret

putc:
	movl	%esi,		%eax		// al
	movb	$0x0e,		%ah
	movw	$0x0007,	%bx
	int	$0x10
	ret

// unused
	/*
putchar:
	pushl	%ebp
	movl	%esp,	%ebp
	subl	$4,	%esp

	movl	8(%ebp),%eax
#	movb	%ah,	%al
	movb	$0x0e,	%ah
	movw	$0x07,	%bx
	int	$0x10
        jmp	L1
L1:
	leave
	ret
*/
// putx (char *p)
putx:
	lodsb
	cmpb	$0,		%al
	je	.P1

	movb	$0x0e,		%ah
	movw	$0x07,		%bx
	int	$0x10

	jne	putx
.P1:
	ret
/*
puts:
	pushl	%ebp
	movl	%esp,	%ebp
	subl	$4,	%esp
	movl	8(%ebp),%eax	# 1st
	pushl	%eax
        movl	12(%ebp),%eax
	pushl	%eax
#	# get cursor's place
        movb	$0x03,	%ah
        xorb	%bh,	%bh
        int	$0x10

	popl	%eax
        movl	%eax	,%ecx

	popl	%eax
        movl	%eax,	%ebp

        movb	$0x07,	%bl
        movw	$0x1301,%ax
        int	$0x10
	popl	%ebp
	movl	%esp,	%ebp
        jmp	L2
L2:
	leave
	ret
*/
# the end of false
hell:
	movl	$NO,		%esi
	call	putx
	jmp	endloop
endloop:
	jmp endloop				# never end...


video_init:
	movb	$0x00,	%ah
//	movb	$0x72,	%al
//	movb	$0x72|0x01<<7,	%al	// Video mode
	movb	$0x12,	%al	// Video mode
//	movb	$0x12|0x01<<7,	%al	// Video mode
//	movb	$0x52,	%al	// Video mode
//	orb	$0x80,	%al
	int	$0x10

	movw	$0x0004,%cx
	movb	$0x01,	%ah
	int	$0x10
	ret

/* message data. */

phase00:
        .ascii	"Phase00:boot\n\r"
	.byte	0
#        .byte 13, 10
msg_sect:
	.ascii	" secter loaded. "
	.byte	0
OK:
	.ascii	"OK\n\r"
	.byte	0
NO:
	.ascii	"NO\n\r"
	.byte	0
FDRESET:
	.ascii	" FD reset: "
	.byte	0
LOADWAKE:
	.ascii	" Load wake: "
	.byte	0

/* message data end. */

pad:
        .org	510		// padding
magic:
        .word	0xaa55		// Magic Number
/* EOF */
