/** @file	boot.h
 *  @brief	boot
 *  Copyright (c) kaworu
 *  $Id: boot.h,v 1.1.1.1 2003/10/12 18:01:01 kaworu Exp $
 *  @author	kaworu
 *  @date	since 2003/06/21 update: $Date: 2003/10/12 18:01:01 $
 *  @version	$Revision: 1.1.1.1 $
 */

/*
how to use memory

0x07c00		boot
0x90000		wake
0x90200		standup
 */

#ifndef BOOT_H
#define BOOT_H

#define	BOOTSEG		0x07c0
#define	INITSEG		0x9000
#define	SETUPSEG	0x9020
#define WAKESEG		0x9020
#define DUMMYSEG	0x9060

#define PROG1SEG	0x07c0
#define SYSSEG		0x10000

#define DELTA_INITSEG	SETUPSEG - INITSEG	 /* 0x0020 */
#define SETUPSECTS	0x04


#define CODE16		asm (".code16gcc")
#define CODE32		asm (".code32gcc")

#endif
