/** @file	kernel.S
 *  @brief	start of dummy kernel
 *  Copyright (c) kaworu
 *  $Id: kernel.S,v 1.1.1.1 2003/10/12 18:01:01 kaworu Exp $
 *  @author	kaworu
 *  @date	since 2003/06/21 update: $Date: 2003/10/12 18:01:01 $
 *  @version	$Revision: 1.1.1.1 $
 */
#include "boot.h"

//	.code32		// This runs in protect mode
	.code16gcc	// This runs in real mode
	.text
	.global		start
	.global		putx
	.global		dummy
	.global		xsh
//	.global		kprintf
//	.global		kputs
start:
	pushl	%ebp
	movl	%esp,	%ebp	// stack

	movw	$DUMMYSEG,%ax
	movw	%ax,	%es	// Address
	movw	%ax,	%ds	// data
	xorw	%ax,	%ax	// Zero
	movw	%ax,	%ss	// stack

	movl	$banner,	%esi
	call	putx

//	pushl	$str1
//	call	kprintf
//	call	kputs
loop:
	call	xsh
	jmp loop		// forever
// test
str1:
	.ascii	"str1"
	.byte	0

// putx (char *p)
putx:
	lodsb
	cmpb	$0,		%al
	je	.P1

	movb	$0x0e,		%ah
	movw	$0x07,		%bx
	int	$0x10

	jne	putx
.P1:
	ret

// putchar ('x') for debug
dummy:
	pushl	%ebp
	movl	%esp,	%ebp
	subl	$4,	%esp
	movb	$'x',	%al
	movb	$0x0e,	%ah
	movw	$0x07,	%bx
	int	$0x10

	leave
	ret

start32:
	.long	0x1000

loop32:
	jmp	loop32

delay:
	outb	%al,	$0x80
	ret

// Descriptor table
gdt:				// global descriptor table
	.word	0, 0, 0, 0	// dummy
	.word	0, 0, 0, 0	// unused

	.word	0xffff		// 4GB
	.word	0		// base address = 0
	.word	0x9a00		// code read/exec
	.word	0x00cf		// granularity = 4096, 386

	.word	0xffff		// 4GB
	.word	0		// base address = 0
	.word	0x9a00		// code read/exec
	.word	0x00cf		// granularity = 4096, 386

idt_48:				// interrupt descriptor table
	.word	0		// idt limit = 0
	.word	0,	0	// idt base = 0L
gdt_48:				// global descriptor table
	.word	0x8000		// gdt limit=2048, 256 GDT entries
	.word	0,	0	// gdt base (filled in later)

banner:
        .ascii	"Phase0x:kernel\n\r"
	.byte	0

