/** @file	kernel.ls
 *  @brief	linker script for kernel
 *  Copyright (c) kaworu
 *  $Id: kernel.ls,v 1.1.1.1 2003/10/12 18:01:01 kaworu Exp $
 *  @author	kaworu
 *  @date	since 2003/06/21 update: $Date: 2003/10/12 18:01:01 $
 *  @version	$Revision: 1.1.1.1 $
 */
OUTPUT_FORMAT("binary")			/* We want raw binary image */
OUTPUT_ARCH(i386)
/* Define memory layout */
/*
MEMORY {
  body : org =   0, len = 1024
 }
 */

/* Specify input and output sections */
SECTIONS {
  .text   : { *(.text) }   > body	/* Executable codes */
  .rodata : { *(.rodata*) } > body	/* Constant data (R/O) */
  .data   : { *(.data) }   > body	/* Initialized data */
  .bss    : { *(.bss) }    > body	/* Uninitialized data */
 }
