# 1 "kernel.S"
# 1 "<built-in>"
# 1 "<command line>"
# 1 "kernel.S"





# 1 "../include/boot.h" 1
# 7 "kernel.S" 2


        .code16gcc
        .text
        .global start
        .global putx
        .global dummy
        .global xsh


start:
        pushl %ebp
        movl %esp, %ebp

        movw $0x9060,%ax
        movw %ax, %es
        movw %ax, %ds
        xorw %ax, %ax
        movw %ax, %ss

        movl $banner, %esi
        call putx




loop:
        call xsh
        jmp loop

str1:
        .ascii "str1"
        .byte 0


putx:
        lodsb
        cmpb $0, %al
        je .P1

        movb $0x0e, %ah
        movw $0x07, %bx
        int $0x10

        jne putx
.P1:
        ret


dummy:
        pushl %ebp
        movl %esp, %ebp
        subl $4, %esp
        movb $'x', %al
        movb $0x0e, %ah
        movw $0x07, %bx
        int $0x10

        leave
        ret

start32:
        .long 0x1000

loop32:
        jmp loop32

delay:
        outb %al, $0x80
        ret


gdt:
        .word 0, 0, 0, 0
        .word 0, 0, 0, 0

        .word 0xffff
        .word 0
        .word 0x9a00
        .word 0x00cf

        .word 0xffff
        .word 0
        .word 0x9a00
        .word 0x00cf

idt_48:
        .word 0
        .word 0, 0
gdt_48:
        .word 0x8000
        .word 0, 0

banner:
        .ascii "Phase0x:kernel\n\r"
        .byte 0
