/** @file	wake.S
 *  @brief	wake for boot
 *  Copyright (c) kaworu
 *  $Id: wake.S,v 1.1.1.1 2003/10/12 18:01:01 kaworu Exp $
 *  @author	kaworu
 *  @date	since 2003/06/21 update: $Date: 2003/10/12 18:01:01 $
 *  @version	$Revision: 1.1.1.1 $
 */

#include "boot.h"

	.code16gcc		// This runs in real mode
	.text
	.global		wake
	.global		putx
	.global		dummy
	.global		printb
wake:
	pushl	%ebp
	movl	%esp,	%ebp	// stack

	movw	$WAKESEG,%ax
	movw	%ax,	%es	// Address
	movw	%ax,	%ds	// data
	xorw	%ax,	%ax	// Zero
	movw	%ax,	%ss	// stack

	movl	$phase01,	%esi
	call	putx

	call	fd_stop
//	call	a20_init
	call	mouse_reset
	call	mouse_cursor_show
	call	mouse_set_cursor_place
	call	mouse_set_cursor_text

	ljmp	$DUMMYSEG,	$0x000
	
loop:
	jmp loop		// forever

// putx (char *p)
putx:
	lodsb
	cmpb	$0,		%al
	je	.P1

	movb	$0x0e,		%ah
	movw	$0x07,		%bx
	int	$0x10

	jne	putx
.P1:
	ret

dummy:
	pushl	%ebp
	movl	%esp,	%ebp
	subl	$4,	%esp
	movl	8(%ebp),%eax
	#movb	$'x',	%al
	movb	$0x0e,	%ah
	movw	$0x07,	%bx
	int	$0x10

	leave
	ret

/*
 * Stop the FD motor.
 */
fd_stop:
#if 1
	xorw	%ax,	%ax	# Zero
	xorb	%dl,	%dl	# Zero
	int	$0x13
#else
	movw	$0x3f2,	%dx
	xorb	%al,	%al	# Zero
	outb	%al,	%dx
#endif
	ret

mouse_reset:
	xorw	%ax,	%ax
	int	$0x33
	ret
mouse_cursor_show:
	xorw	$0x01,	%ax
	int	$0x33
	ret
mouse_set_cursor_place:
	movw	$0x04,	%ax	// number
	movw	$0x00,	%cx	// x
	movw	$0x00,	%dx	// y
	int	$0x33
	ret
mouse_set_cursor_text:
	movw	$0x0a,	%ax	// 10
	movw	$0x01,	%bx	// Hardware Cursor(1) / Sofrware Cursor(0)
	movw	$0x00,	%cx
	movw	$0x00,	%dx
	int	$0x33
	ret

// real mode switch routine.
a20_init:
	cli			// Disable Interrupt
disable_NMI:
	movb	$0x80,	%al	// disable NMI for bootup
	outb	%al,	$0x70

a20_notry:
	call	a20_test
	jnz	a20_done	// if system have a20
a20_try:
	call	a20_bios	// not supported bochs
	call	a20_test
	jnz	a20_done

	call	a20_kbc
	call	a20_test
	jnz	a20_done

//	pushl	$27
//	pushl	msg_a20_dead
//	call	puts
	movl	$msg_a20_dead,	%esi
	call	putx

a20_dead:
	jmp	a20_dead

a20_test:
	pushw	%cx
	pushw	%ax
	xorw	%cx,	%cx	// Zero
	movw	%cx,	%fs	// Low memory
	movw	%cx,	%gs	// Hight memory
	movw	$A20_TEST_MAX,	%cx
	movw	%fs:A20_TEST_ADDR, %ax
	pushw	%ax
a20_test_wait:
	incw	%ax
	movw	%ax,	%fs:(A20_TEST_ADDR)
	call	delay
	cmpw	%gs:(A20_TEST_ADDR+0x10), %ax
	loope	a20_test_wait
	popw	%fs:(A20_TEST_ADDR)
	popw	%ax
	popw	%cx
	ret
a20_done:
	movl	$msg_a20_done,	%esi
	call	putx

	lidt	idt_48
	xorl	%eax,	%eax	// Zero
	movw	%ds,	%ax
	shll	$4,	%eax
	addl	$gdt,	%eax
	addl	%eax,	(gdt_48+2)
	lgdt	gdt_48

	# properly reset
	xorw	%ax,	%ax	// Zero
	outb	%al,	$0xf0
	call	delay
	
	outb	%al,	$0xf1
	call	delay

	# all interrupts reset
	movb	$0xff,	%al
	outb	%al,	$0xa1
	call	delay
	
	movb	$0xfb,	%al
	outb	%al,	$0x21

	# cr0(protect mode)
	movw	$1,	%ax	// Protected mode (PE) bit
	lmsw	%ax
	jmp	done
done:
	jmp done
/*
	movl	%cr0,	%eax
	orl	$0x01,	%eax
	movl	%eax,	%cr0
	*/
	jmp	start32
	
//	ret///////////////////////////////////////
start32:
//	.long	0x1000

	/*
	pushl	$14
	pushl	msg_a20_done
	call	puts
	*/
//	ljmp	$DUMMYSEG,	$0x000
	
loop32:
	jmp	loop32

protect:	// sample code...
	movb	$0xd1,	%al	// command write
	outb	%al,	$0x64

	movb	$0xdf,	%al	// A20 enable
	outb	%al,	$0x60
	sti

	lidt	idt_48		// load idt with 0,0
	lgdt	gdt_48		// load gdt with whatever is appropriate

	//	lgdt	gdt
	movl	%cr0,	%eax
	orl	$0x01,	%eax
	movl	%eax,	%cr0

	ret

	// Try BIOS (int 0x15, AX=0x2401
a20_bios:
	movw	$0x2401,%ax
	pushfl
	int	$0x15
	popfl
	ret
a20_kbc:
	movb	$0xd1,	%al	// command write
	outb	%al,	$0x64	// 0xd1 -> I/O port 64H

	movb	$0xdf,	%al	// A20 on
	outb	%al,	$0x60	// 0xfd -> I/O port 60H
a20_kbc_wait:
	xorw	%cx,	%cx	// Zero
a20_fast:
	inb	$0x92,	%al
	orb	$0x02,	%al
	andb	$0xfe,	%al
	outb	%al,	$0x92
a20_fast_wait:
	xorw	%cx,	%cx
	ret

delay:
	outb	%al,	$0x80
	ret

// Descriptor table
gdt:				// global descriptor table
	.word	0, 0, 0, 0	// dummy
	.word	0, 0, 0, 0	// unused

	.word	0xffff		// 4GB
	.word	0		// base address = 0
	.word	0x9a00		// code read/exec
	.word	0x00cf		// granularity = 4096, 386

	.word	0xffff		// 4GB
	.word	0		// base address = 0
	.word	0x9a00		// code read/exec
	.word	0x00cf		// granularity = 4096, 386

idt_48:				// interrupt descriptor table
	.word	0		// idt limit = 0
	.word	0,	0	// idt base = 0L
gdt_48:				// global descriptor table
	.word	0x8000		// gdt limit=2048, 256 GDT entries
	.word	0,	0	// gdt base (filled in later)

A20_TEST_MAX:
	.word	32
A20_TEST_ADDR:
	.word	4*0x80
phase01:
        .ascii	"Phase01:wake\n\r"
	.byte	0
msg_a20_done:
	.ascii	" Protect mode\n\r\0"
msg_a20_dead:
	.ascii	" Can't switch protect mode\0"
/*
pmagic:
	.org 510
	.word	0xaa55
*/

