//
// AScript sample module
//

#define ASCRIPT_DLL_MODULE
#include "AScript.h"

AScript_BeginModule(sample)

// sample.skeleton()
AScript_DeclareFunction(skeleton)
{
	SetMode(RSLTMODE_Normal, MAP_Off);
}

AScript_ImplementFunction(skeleton)
{
	return Value::Null;
}

// result = sample.adder(num1:number, num2:number)
AScript_DeclareFunction(adder)
{
	SetMode(RSLTMODE_Normal, MAP_Off);
	DeclareArg(env, _T("num1"), VTYPE_Number);
	DeclareArg(env, _T("num2"), VTYPE_Number);
}

AScript_ImplementFunction(adder)
{
	return Value(context.GetNumber(0) + context.GetNumber(1));
}

// result = sample.adder2(num1:number, num2:number):map
// automapping version of adder(). see differences in their implementations.
AScript_DeclareFunction(adder2)
{
	SetMode(RSLTMODE_Normal, MAP_On);
	DeclareArg(env, _T("num1"), VTYPE_Number);
	DeclareArg(env, _T("num2"), VTYPE_Number);
}

AScript_ImplementFunction(adder2)
{
	return Value(context.GetNumber(0) + context.GetNumber(1));
}

// Module entry
AScript_ModuleEntry()
{
	AScript_AssignValue(Symbol::Add(_T("foo")),
								Value(env, _T("a value in sample module")));
	AScript_AssignFunction(skeleton);
	AScript_AssignFunction(adder);
	AScript_AssignFunction(adder2);
}

AScript_EndModule(sample)

AScript_DLLModuleEntry(sample)
