//---------------------------------------------------------------------------
//Charactor set is UTF-8
//漢字コードはＵＴＦ－８
//---------------------------------------------------------------------------
$(document).ready(function () {
//初期設定
	$.ajaxSetup({async : false});								//同期通信にする
	$('.cPseudLink').click(CmdDispatch);						//すべての疑似リンクにイベントを付ける
	$('#iAllCheck').click(CmdDispatch);
	$('#iUpLoadButton').click(CmdDispatch);						//ダイアローグのボタンにイベントを付ける
	$('#iMkDirButton').click(CmdDispatch);
	$('#iRenButton').click(CmdDispatch);
	$('#iDirTreeDlogButton').click(CmdDispatch);

	$('#iDirList').hide();										//ダイアローグを隠す
	$('#iUpLoadDlog').hide();
	$('#iMkDirDlog').hide();
	$('#iRenDlog').hide();
	$('#iInfo').hide();

	$("#iMainTable tr:even" ).css("background-color","#e0e0ff");	//一覧表に色を付ける　偶数行
	$("#iMainTable tr:odd"  ).css("background-color","#ffffff");	//奇数行
	$("#iMainTable tr:first").css("background-color","#c0c0ff");	//一番上
});
//---------------------------------------------------------------------------
function CmdDispatch()
//コマンドディスパッチルーチン
//引数		this.id : IDがコマンドを兼ねる
{
	var		id;

	id = this.id

	$('#iCmd').val(id);
	switch(id) {
		case 'iMoveDir':		MoveDir();break;			//ディレクトリ移動
		case 'iMkDir':			MkDir();break;				//ディレクトリを作るダイアローグを表示する
		case 'iView':			View();break;				//ファイルの中身を表示する
		case 'iEdit':			Edit();break;				//テキストファイルを編集する
		case 'iCopy':			Copy();break;				//ファイルを複製する
		case 'iMove':			Move();break;				//ファイルを移動する
		case 'iDel':			Del();break;				//ディレクトリやファイルを削除する
		case 'iRen':			Ren();break;				//ディレクトリやファイル名を変更する
		case 'iUp':				Up();break;					//ファイルをアップロードする
		case 'iSortName1':		SortName(1);break;			//ソート
		case 'iSortName2':		SortName(2);break;
		case 'iSortSize1':		SortSize(1);break;
		case 'iSortSize2':		SortSize(2);break;
		case 'iSortDate1':		SortDate(1);break;
		case 'iSortDate2':		SortDate(2);break;
		case 'iAllCheck':		ToggleCheckBox();break;		//チェックボックスをすべて反転させる
		case 'iUpLoadButton':	UpLoadButton();break;		//アップロード実行
		case 'iMkDirButton':	MkDirButton();break;		//ディレクトリ作成実行
		case 'iRenButton':		RenButton();break;			//名前変更実行
		case 'iAbout':			About();break;				//このソフトについて
		case 'iDirTreeDlogButton':	DirTreeDlog();break;	//ディレクトリ選択ダイアローグの「決定」ボタンが押された
		default :		alert( "[" + id + "] is not valid function" );
	}
}
//---------------------------------------------------------------------------
function MoveDirA(pDir)
//ディレクトリ移動コマンド－絶対パス指定
//引数		pDir : 移動先ディレクトリ
{
	$('#iCmd').val('ChDir');
	$('#iSelDir').val(pDir);
	$('#iCmdForm').submit();
}
//---------------------------------------------------------------------------
function MoveDirB(pDir)
//ディレクトリ移動コマンド－下のディレクトリ
//引数		pDir : 移動先ディレクトリ
{
	$('#iCmd').val('ChDir');
	$('#iSelDir').val($('#iDir').val() + pDir);
	$('#iCmdForm').submit();
}
//---------------------------------------------------------------------------
function DownLoad(pFileName)
//ダウンロード
//引数	pFileName : ダウンロードするファイル名
{
	$('#iCmd').val('DownLoad');
	$('#iFile').val(pFileName);
	$('#iCmdForm').submit();
}
//---------------------------------------------------------------------------
