//---------------------------------------------------------------------------
//Charactor set is UTF-8
//漢字コードはＵＴＦ－８
//---------------------------------------------------------------------------
function MoveDir()
//ディレクトリ移動
{
	$("#iDirTreeDlog").load('index.php',{'nCmd' : 'DirTree'});
	$("#iDirList").show();
	$("#iDirList").treeview({collapsed : true});	//ツリーは閉じて表示する
	$("#iDirListCmd").val('ChDir');
}
//---------------------------------------------------------------------------
function MkDir()
//ディレクトリを作るダイアローグを表示する
{
	$("#iMkDirDlog").show();
}
//---------------------------------------------------------------------------
function View()
//ファイルの中身を表示する
{
	var		filetype,filename,dir;

	if(! OnlyOneFile()) return;

	filename = $("input[name='nFiles[]']:checked").val();
	dir      = $("#iDir").val();

	$.post('index.php',{'nCmd' : 'IsVisible' , 'nFileName' : filename} , function (ret) {
			filetype = ret;
		},'text');

	if(filetype == 'Not Visible') {
		alert(filename + gMsg['NotVisible']);
		return;
	}
	switch(filetype) {
		case 'TEXT':	param = 'nCmd=ViewText&nFileName='  + filename + '&nDir=' + dir;break;
		case 'IMAGE':	param = 'nCmd=ViewImage&nFileName=' + filename + '&nDir=' + dir;break;
	}
	param = encodeURI(param);
	opt = 'toolbar=no,location=no,directories=no,status=no,menubar=no,scrollbars=yes,resizable=yes';//１つ指定するとデフォルトが全部消える
	win = window.open('index.php' + '?' + param,"ViewFile",opt);				//別ウインドウ表示
}
//---------------------------------------------------------------------------
function Edit()
//テキストファイルを編集する
{
	var		filetype,filename,dir;

	if(! OnlyOneFile()) return;

	filename = $("input[name='nFiles[]']:checked").val();
	dir      = $("#iDir").val();

	$.post('index.php',{'nCmd' : 'IsText' , 'nFileName' : filename} , function (ret) {
		filetype = ret;
		},'text');

	if(filetype != 'TEXT') {
		alert(filename + gMsg['NotEditable']);
		return;
	}

	param = 'nCmd=EditText&nFileName='  + filename + '&nDir=' + dir;
	param = encodeURI(param);
	opt = 'toolbar=no,location=no,directories=no,status=no,menubar=no,scrollbars=yes,resizable=yes';//１つ指定するとデフォルトが全部消える
	win = window.open('index.php' + '?' + param,"EditText",opt);				//別ウインドウ表示
}
//---------------------------------------------------------------------------
function Copy()
//ファイルを複製する
{
	if(! SomeDirsFiles()) return;

	$("#iDirTreeDlog").load('index.php',{'nCmd' : 'DirTree'});
	$("#iDirList").show();
	$("#iDirList").treeview({collapsed : true});	//ツリーは閉じて表示する
	$("#iDirListCmd").val('CopyFiles');
}
//---------------------------------------------------------------------------
function Move()
//ファイルを移動する
{
	if(! SomeDirsFiles()) return;

	$("#iDirTreeDlog").load('index.php',{'nCmd' : 'DirTree'});
	$("#iDirList").show();
	$("#iDirList").treeview({collapsed : true});	//ツリーは閉じて表示する
	$("#iDirListCmd").val('MoveFiles');
}
//---------------------------------------------------------------------------
function Del()
//ディレクトリやファイルを削除する
{
	if(! SomeDirsFiles()) return;

	if(! confirm(gMsg['DeleteOK'])) return;
	$("#iCmd").val('Delete');
	$("#iCmdForm").submit();
}
//---------------------------------------------------------------------------
function Ren()
//ディレクトリやファイル名を変更する
{
	var		item;

	if(! OnlyOneDirFile()) return;

	item = $("input[name='nFiles[]']:checked").size();
	if(item == 1) {
		item = $("input[name='nFiles[]']:checked").val();
		$("#iType").val('File');
	} else {
		item = $("input[name='nDirs[]']:checked").val();
		item = item.substr(0,item.length - 1);
		$("#iType").val('Dir');
	}
	$("#iOldName").val(item);
	$("#iNewName").val(item);
	$("#iRenDlog").show();
}
//---------------------------------------------------------------------------
function Up()
//ファイルをアップロードする
{
	$("#iUpLoadDlog").show();
}
//---------------------------------------------------------------------------
function SortName(pSort)
//ソート
//引数	pSort : ソート方法 1 or 2
{
	if(pSort == 1) {
		$("#iSort").val("name_up");
	} else {
		$("#iSort").val("name_down");
	}
	$("#iCmd").val("Sort");
	$("#iCmdForm").submit();
}
//---------------------------------------------------------------------------
function SortSize(pSort)
//ソート
//引数	pSort : ソート方法 1 or 2
{
	if(pSort == 1) {
		$("#iSort").val("size_up");
	} else {
		$("#iSort").val("size_down");
	}
	$("#iCmd").val("Sort");
	$("#iCmdForm").submit();
}
//---------------------------------------------------------------------------
function SortDate(pSort)
//ソート
//引数	pSort : ソート方法 1 or 2
{
	if(pSort == 1) {
		$("#iSort").val("date_up");
	} else {
		$("#iSort").val("date_down");
	}
	$("#iCmd").val("Sort");
	$("#iCmdForm").submit();
}
//---------------------------------------------------------------------------
function ToggleCheckBox()
//チェックボックスをすべて反転させる
{
	if($('#iAllCheck').attr('checked')) {
		$("input[name='nDirs[]']").attr('checked',true);
		$("input[name='nFiles[]']").attr('checked',true);
	} else {
		$("input[name='nDirs[]']").attr('checked',false);
		$("input[name='nFiles[]']").attr('checked',false);
	}
}
//---------------------------------------------------------------------------
function UpLoadButton()
//アップロード実行
{
	var		file,flag;

	flag = 0;
	$("input[name='nUP[]']").each(function () {
		file = this.value;
		flag = flag + file.length;
	});

	if(flag == 0) {
		alert(gMsg['NoUploadFile']);
		return;
	}
	$("#iUpLoadForm").submit();
}
//---------------------------------------------------------------------------
function MkDirButton()
//ディレクトリ作成実行
{
	var		DirName;

	DirName = $("#iMkDirName").val();
	if(false == IsValidName(DirName)) return;
	if(true  == IsExistDir(DirName)) return;
	$('#iMkDirDlog').hide();
	$("#iMkDirForm").submit();
}
//---------------------------------------------------------------------------
function IsValidName(pStr)
//名前が妥当かどうか検査する
//引数		pStr：検査する文字列
//戻り値	true:妥当　false:妥当でない
{
	if(pStr == '') {
		alert(gMsg['NoInput']);
		return false;
	}

	if(pStr.match(/[\\/:*?"<>|+]/)) {
		alert(gMsg['InvalidChar']);
		return false;
	}
	return true;
}
//---------------------------------------------------------------------------
function IsExistDir(pStr)
//すでにディレクトリが存在するかどうか
//戻り値	false:存在しない true:存在する（重複する）
{
	var		nameA,nameB,flag;

	nameA = pStr.toLowerCase() + '/';

	flag = false;
	$("input[name='nDirs[]']").each(function () {
		nameB = this.value;
		nameB = nameB.toLowerCase();

		if(nameA == nameB) flag = true;
	});

	if(flag == true) alert(gMsg['SameFolderExist']);
	return flag;
}
//---------------------------------------------------------------------------
function IsExistFile(pStr)
//すでにファイルが存在するかどうか
//戻り値	false:存在しない true:存在する（重複する）
{
	var		nameA,nameB,flag;

	nameA = pStr.toLowerCase();

	flag = false;
	$("input[name='nFiles[]']").each(function () {
		nameB = this.value;
		nameB = nameB.toLowerCase();

		if(nameA == nameB) flag = true;
	});

	if(flag == true) alert(gMsg['SameFileExist']);
	return flag;
}
//---------------------------------------------------------------------------
function RenButton()
//名前変更実行
{
	var		name;

	name = $("#iNewName").val();
	if(false == IsValidName(name)) return;
	if($("#iType").val() == 'Dir') {
		if(true  == IsExistDir(name)) return;
	} else {
		if(true == IsExistFile(name)) return;
	}
	$("#iRenForm").submit();
}
//---------------------------------------------------------------------------
function About()
//このソフトについて
{
	$('#iInfo').load('index.php',{'nCmd' : 'About'});	//このソフトについて
	$('#iInfo').show();
}
//---------------------------------------------------------------------------
function DirTreeDlog()
//ディレクトリ選択ダイアローグの「決定」ボタンが押された
{
	var		dir,cmd;

	dir = $("input[name='nSelectedDir']:checked").size();
	if(dir == 0) {
		alert(gMsg['NoFolderSelected']);
		return;
	}

	cmd = $("#iDirListCmd").val();
	dir = $("input[name='nSelectedDir']:checked").val();

	if(((cmd == 'CopyFiles') || (cmd == 'MoveFiles')) && ContainSameDir()) {
		alert(gMsg['ContainSameDir']);
		return;
	}

	$("#iCmd").val(cmd);
	$("#iSelDir").val(dir);
	$("#iCmdForm").submit();
}
//---------------------------------------------------------------------------
function OnlyOneFile()
//ファイルが１つだけ選択されているかどうか
//戻り値		false : 0または2つ以上のファイルが選択されている
//				true  : 1つのファイルが選択されている
{
	var		files;

	files = $("input[name='nFiles[]']:checked").size();
	if(files == 0) {
		alert(gMsg['NoFileSelected']);
		return false;
	}
	if(files >= 2) {
		alert(gMsg['SomeFileSelected']);
		return false;
	}

	return true;
}
//---------------------------------------------------------------------------
function SomeFiles()
//ファイルが１つ以上選択されているか
//戻り値		false : １つもファイルが選択されていないファイルが選択されている
//				true  : １つ以上のファイルが選択されている
{
	var		files;

	files = $("input[name='nFiles[]']:checked").size();
	if(files == 0) {
		alert(gMsg['NoFileSelected']);
		return false;
	}

	return true;
}
//---------------------------------------------------------------------------
function SomeDirsFiles()
//フォルダーやファイルが１つ以上選択されているか
//戻り値		false : １つもフォルダーやファイルが選択されていないファイルが選択されている
//				true  : １つ以上のフォルダーやファイルが選択されている
{
	var		files,dirs;

	files = $("input[name='nFiles[]']:checked").size();
	dirs  = $("input[name='nDirs[]']:checked").size();
	if(files + dirs == 0) {
		alert(gMsg['NoFolderFileSelected']);
		return false;
	}

	return true;
}
//---------------------------------------------------------------------------
function OnlyOneDirFile()
//ファイルが１つだけ選択されているかどうか
//戻り値		false : 0または2つ以上のファイルが選択されている
//				true  : 1つのファイルが選択されている
{
	var		files,dirs;

	files = $("input[name='nFiles[]']:checked").size();
	dirs  = $("input[name='nDirs[]']:checked").size();

	if(files + dirs == 0) {
		alert(gMsg['NoFolderFileSelected']);
		return false;
	}
	if(files + dirs >= 2) {
		alert(gMsg['SomeFolderFileSelected']);
		return false;
	}

	return true;
}
//---------------------------------------------------------------------------
function ContainSameDir()
//ダイアローグで選択したフォルダーがメインウインドウで選択したフォルダー（複数）に含まれているかどうか
//戻り値	true : 含まれている
{
	var		dir_a,dir_c,ret;

	ret = false;
	dir_c = $("#iDir").val();								//現在のディレクトリ
	dir_a = $("input[name='nSelectedDir']:checked").val();	//ダイアローグで選択されたディレクトリ
	$("input[name='nDirs[]']:checked").each(function () {
		if(dir_c + $(this).val() == dir_a) {
			ret = true;										//無名関数の中まで外部の変数は有効？
		}
	});

	return ret;
}
//---------------------------------------------------------------------------
