<?php
//---------------------------------------------------------------------------
//Charactor set is UTF-8
//漢字コードはＵＴＦ－８
//---------------------------------------------------------------------------
function IsVisible()
//ファイルを表示できるかどうか Ajaxで答える
//引数		$_POST['nFileName'] : ファイル名
{
	include('prog/extlist.inc');		//ファイルリスト

	$FilePath = pathinfo($_POST['nFileName']);
	if(! isset($FilePath['extension'])) {
		echo "Not Visible";
		return;
	}

	$ext = $FilePath['extension'];
	foreach($gTextFile as $val) {
		if($val == $ext) {
			echo "TEXT";
			return;
		}
	}
	foreach($gImageFile as $val) {
		if($val == $ext) {
			echo "IMAGE";
			return;
		}
	}

	echo "Not Visible";
}
//---------------------------------------------------------------------------
function ViewText()
//テキストファイルを別ウインドウで表示
//引数		$_GET['nFileName'] : ファイル名
//			$_GET['nDir'] : 現在のディレクトリ $gRootDir . $_GET['nDir'] . $_GET['nFileName']でフルパスになる
{
	global	$gLang,$gRootDir,$gCharSet,$gMsg;

	$filename = mb_convert_encoding($_GET['nFileName'],"UTF-8",$gCharSet);
	$title = "View Text : " . $filename;
	include('prog/html05.inc');
	printf("<pre style=\"margin : 0.5em; font-size : 1em;background-color : white\">\n");

	$text = @file_get_contents($gRootDir . $_GET['nDir'] . $_GET['nFileName']);
	if($text == false) {
		printf($gMsg['CanNotOpen'],$filename);
	} else {
		$charset = mb_detect_encoding($text,"JIS,SJIS,UTF-8,EUC-JP,ASCII");	//autoはうまくいかないことがある
		$text    = mb_convert_encoding($text,"UTF-8",$charset);				//編集のために文字コードを変える
		$text    = htmlentities($text,ENT_QUOTES,"UTF-8");
		echo $text;
	}
	printf("</pre>\n<!-- CharSet = {$charset} -->\n</body>\n</html>\n");
}
//---------------------------------------------------------------------------
function ViewImage()
//画像ファイルを別ウインドウで表示
//引数		$_GET['nFileName'] : ファイル名
//			$_GET['nDir'] : 現在のディレクトリ $gRootDir . $_GET['nDir'] . $_GET['nFileName']でフルパスになる
{
	global	$gLang,$gCharSet;

	$FileName = $_GET['nDir'] . $_GET['nFileName'];					//OS上の名前(OSの文字コード)
	$FileName = mb_convert_encoding($FileName,"UTF-8",$gCharSet);	//ブラウザに表示するときの文字コード
	$FileName = urlencode($FileName);								//imgタグでリンクする

	$title = "View Image : " . mb_convert_encoding($_GET['nFileName'],"UTF-8",$gCharSet);
	include('prog/html05.inc');
	printf("<pre style=\"margin : 0.5em; font-size : 1em\">\n");
	printf("<img src=\"index.php?nCmd=SendImage&nFileName=%s\" alt=\"\">\n",$FileName);
	printf("</pre>\n</body>\n</html>\n");
}
//---------------------------------------------------------------------------
function SendImage()
//画像データを送る
//引数		$_GET['nFileName'] : ファイル名  $gRootDir . $_GET['nFileName']でフルパスになる
{
	global	$gRootDir;

	$fname = $gRootDir . $_GET['nFileName'];
	$size     = filesize($fname);
	$FileInfo = pathinfo($fname);

	header("Content-Type: image/" . $FileInfo['extension']);	//MIMEヘッダ
	header("Content-length: "     . $size);						//ファイルサイズ
	readfile($fname);											//ファイル出力
}
//---------------------------------------------------------------------------
?>
