<?php
//---------------------------------------------------------------------------
//Charactor set is UTF-8
//漢字コードはＵＴＦ－８
//---------------------------------------------------------------------------
function UniqName($pPath,$pName)
//ファイル名に (n) を付けてユニークなファイル名を作る
//引数		$pPath：パス（最後の / 付き)
//			$pNameファイル名
//戻り値	ユニークなファイル名を返す
{
	$path = $pPath . $pName;
	if(! file_exists($path)) return($pName);

	$ext = pathinfo($pName,PATHINFO_EXTENSION);		//PHP5のpathinfoはマルチバイトに対応していない
	if($ext != '') {
		$name = substr($pName,0,strlen($pName) - strlen($ext) - 1);
	} else {
		$name = $pName;
	}
	for($c=1;;$c++) {
		$path = sprintf("%s%s-%02d.%s",$pPath,$name,$c,$ext);
		if(! file_exists($path)) break;
	}

	$path = sprintf("%s-%02d.%s",$name,$c,$ext);
	return($path);
}
//---------------------------------------------------------------------------
function UniqDirName($pPath,$pDir)
//ディレクトリ名に (n) を付けてユニークなディレクトリ名を作る
//引数		$pPath：パス（最後の / 付き)
//			$pDir : ディレクトリ名（最後の / 付き)
//戻り値	ユニークなディレクトリ名を返す
{
	$path = $pPath . $pDir;
	if(! file_exists($path)) return($pDir);

	$name = substr($pDir,0,strlen($pDir) - 1);
	for($c=1;;$c++) {
		$path = sprintf("%s%s-%02d/",$pPath,$name,$c);
		if(! file_exists($path)) break;
	}

	$path = sprintf("%s-%02d/",$name,$c);
	return($path);
}
//---------------------------------------------------------------------------
?>
