/*!
  \file
  \brief xԂ𐧌\ delay() ֐

  \author Satofumi KAMIMURA

  $Id$
*/

#include "Delay.h"
#include "SdlInit.h"
#include <SDL.h>


double WaitRatio = 1.0;
SDL_mutex* Mutex = NULL;

class SdlInitClass : private SdlInit {
};

static void mutexInitialize(void) {
  static SdlInitClass sdl_init;
  static SDL_mutex* obj = SDL_CreateMutex();
  Mutex = obj;
}


void delay(unsigned long msec) {
  mutexInitialize();

  SDL_LockMutex(Mutex);
  unsigned long delay_msec =
    static_cast<unsigned long>(msec * WaitRatio);
  SDL_UnlockMutex(Mutex);

  SDL_Delay(delay_msec);
}


void setDelayRatio(double ratio) {
  mutexInitialize();

  SDL_LockMutex(Mutex);
  WaitRatio = ratio;
  SDL_UnlockMutex(Mutex);
}
