#ifndef TCPIP_ACCEPT_H
#define TCPIP_ACCEPT_H

/*!
  \file
  \brief TCP/IP ڑp|[g

  \author Satofumi KAMIMURA

  $Id$
*/

#include <memory>

class TcpipCtrl;
class SocketSet;


/*!
  \brief TCP/IP ڑ̃T[o
*/
class TcpipAccept {
  TcpipAccept(const TcpipAccept& rhs);
  TcpipAccept& operator = (const TcpipAccept& rhs);

  struct pImpl;
  const std::auto_ptr<pImpl> pimpl;

public:
  explicit TcpipAccept(void);
  ~TcpipAccept(void);
  const char* what(void);
  bool activate(unsigned short port);
  void deactivate(void);
  bool isActivated(void);
  TcpipCtrl* accept(int timeout, SocketSet* socketSet = NULL);
};

#endif /* !TCPIP_ACCEPT_H */
