#ifndef USB_JOYSTICK_H
#define USB_JOYSTICK_H

/*!
  \file
  \brief USB WCXeBbN

  \author Satofumi KAMIMURA

  $Id$
*/

#include "JoystickInterface.h"
#include <SDL.h>
#include <memory>


class UsbJoystick : public JoystickInterface {
  UsbJoystick(const UsbJoystick& rhs);
  UsbJoystick& operator = (const UsbJoystick& rhs);

  struct pImpl;
  const std::auto_ptr<pImpl> pimpl;

public:
  UsbJoystick(void);
  ~UsbJoystick(void);

  const char* what(void);
  size_t getJoystickNum(void);
  void setEvent(SDL_Event& event);

  enum { Auto = -1 };
  bool connect(int index = Auto);
  void disconnect(void);
  bool isConnected(void);

  const char* getProductInfo(void);
  size_t getNumAxis(void);
  size_t getNumButtons(void);
  short getAxisValue(size_t index);
  bool isButtonPressed(size_t index);
};

#endif /* ! USB_JOYSTICK_H */
