/*******************************************************************************
 * Copyright (c) 2009 Information-technology Promotion Agency, Japan.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *******************************************************************************/
package benten.ui.preference;

import org.eclipse.jface.preference.IPreferenceStore;

import benten.ui.UiPlugin;

/**
 * Benten 設定定義。
 *
 * <UL>
 * <LI>Benten 全体で使用する設定定義クラスです。
 * <LI>設定するプラグインが存在しない場合、取得できる値は {@link BentenPreferenceInitializer} のデフォルト値となります。
 * </UL>
 *
 * @author KASHIHARA Shinji
 * @author IGA Tosiki
 */
public class BentenPreference {

	/** 設定保管キー */
	public static enum Preference {

		/** TM 名 */
		TM_NAME,

		/** TMX デフォルトの使用 */
		USE_TMX_DEFAULT,

		/** TMX ロケーションの使用 */
		USE_TMX_LOCATION,

		/** TMX ロケーション */
		TMX_LOCATION,

		/** TM 参照時にホワイトスペースを無視 */
		IGNORE_WHITESPACE_TM_REFERENCE,

		/** TMX 抽出時にホワイトスペースを無視 */
		IGNORE_WHITESPACE_TMX_EXTRACT,

		/** TM 参照時にニーモニック・キーを無視 */
		IGNORE_MNEMONIC_KEY_TM_REFERENCE,

		/** TMX 抽出時にニーモニック・キーを無視 */
		IGNORE_MNEMONIC_KEY_TMX_EXTRACT,

		/** 用語集名 */
		GLOSSARY_NAME,

		/** TSV デフォルトの使用 */
		USE_TSV_DEFAULT,

		/** TSV ロケーションの使用 */
		USE_TSV_LOCATION,

		/** TSV ロケーション */
		TSV_LOCATION,

		// 翻訳元・先の設定。これらは、TM エンジンおよび用語集エンジンで利用される予定。

		/** 翻訳元の言語 */
		TRANS_SOURCE_LANG,

		/** 翻訳先の言語 */
		TRANS_TARGET_LANG,

		/** 基軸言語 */
		TRANS_PIVOT_LANG,
	}

	/**
	 * Benten 設定ストアを取得。
	 * @return Benten 設定ストア
	 */
	public static IPreferenceStore getStore() {
		return UiPlugin.getDefault().getPreferenceStore();
	}
}
