/*******************************************************************************
 * Copyright (c) 2009 Information-technology Promotion Agency, Japan.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *******************************************************************************/
package benten.ui.preference;

import org.eclipse.core.resources.IProject;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.swt.SWT;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.ui.IWorkbenchPropertyPage;
import org.eclipse.ui.dialogs.PropertyPage;

import benten.ui.preference.BentenProjectProperty.ProjectProperty;
import benten.ui.preference.messages.BentenProjectPropertyPageMessages;
import benten.ui.views.UiToolkit;

/**
 * Benten 翻訳プロジェクト・プロパティーのトップ・ページ。
 * 
 * @author KASHIHARA Shinji
 * @author IGA Tosiki
 */
public class BentenProjectPropertyPage extends PropertyPage implements IWorkbenchPropertyPage {
	/**
	 * Benten 翻訳プロジェクトのプロパティー・ページのためのメッセージ。
	 */
	protected static final BentenProjectPropertyPageMessages fMsg = new BentenProjectPropertyPageMessages();

	/**
	 * Benten が提供する基本的なウィジェットを生成する UI ツールキットのインスタンス。
	 */
	private final UiToolkit toolkit = new UiToolkit();

	/** プリファランス・ストア。 */
	private IPreferenceStore projectStore;

	@Override
	protected Control createContents(final Composite parent) {
		// noDefaultAndApplyButton();

		final Composite composite = toolkit.createComposite(parent, 1);
		projectStore = BentenProjectProperty.getStore((IProject) getElement());

		final Group promptGroup = new Group(composite, SWT.BOLD);
		promptGroup.setLayout(toolkit.createGridLayout(2, 5));
		promptGroup.setLayoutData(new GridData(GridData.FILL_HORIZONTAL));
		promptGroup.setText(fMsg.getLabelGroupTransLang());

		{
			final String lang = projectStore.getString(ProjectProperty.TRANS_SOURCE_LANG.name());
			toolkit.createLabel(promptGroup, fMsg.getLabelSourceLang());
			toolkit.createLabel(promptGroup, lang);
		}

		{
			final String lang = projectStore.getString(ProjectProperty.TRANS_TARGET_LANG.name());
			toolkit.createLabel(promptGroup, fMsg.getLabelTargetLang());
			toolkit.createLabel(promptGroup, lang);
		}

		return composite;
	}
}
