/*
 * Copyright (c) 2009 Information-technology Promotion Agency, Japan.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 */
package benten.twa.cat.core.valueobject;

/**
 * 処理クラス [BentenApplyExistentTranslationProcess]の入力バリューオブジェクトクラスです。
 */
public class BentenApplyExistentTranslationProcessInput {
    /**
     * verboseモードで動作させるかどうか。
     *
     * フィールド: [verbose]。
     * デフォルト: [false]。
     */
    private boolean fVerbose = false;

    /**
     * 適用先 XLIFF が格納されているディレクトリ。
     *
     * フィールド: [targetdir]。
     */
    private String fTargetdir;

    /**
     * 適用元(過去訳) XLIFF が格納されているディレクトリ。
     *
     * フィールド: [sourcedir]。
     */
    private String fSourcedir;

    /**
     * 翻訳元言語
     *
     * フィールド: [transsourcelang]。
     * デフォルト: [en-US]。
     */
    private String fTranssourcelang = "en-US";

    /**
     * 翻訳先言語
     *
     * フィールド: [transtargetlang]。
     * デフォルト: [ja-JP]。
     */
    private String fTranstargetlang = "ja-JP";

    /**
     * Ant タスクの場合には、TM ドライバーのクラス名を指定します。
     *
     * フィールド: [tmdriverclassname]。
     */
    private String fTmdriverclassname;

    /**
     * TMX を検索する際にホワイトスペースを無視するかどうか。
     *
     * フィールド: [ignorewhitespacetmreference]。
     * デフォルト: [false]。
     */
    private boolean fIgnorewhitespacetmreference = false;

    /**
     * TMX を検索する際にニーモニックを無視するかどうか。
     *
     * フィールド: [ignoremnemonickeytmreference]。
     * デフォルト: [false]。
     */
    private boolean fIgnoremnemonickeytmreference = false;

    /**
     * テンポラリ・ディレクトリ
     *
     * フィールド: [tmpdir]。
     * デフォルト: ["./tmp"]。
     */
    private String fTmpdir = "\"./tmp\"";

    /**
     * フィールド [verbose] の値を設定します。
     *
     * フィールドの説明: [verboseモードで動作させるかどうか。]。
     *
     * @param argVerbose フィールド[verbose]に設定する値。
     */
    public void setVerbose(final boolean argVerbose) {
        fVerbose = argVerbose;
    }

    /**
     * フィールド [verbose] の値を取得します。
     *
     * フィールドの説明: [verboseモードで動作させるかどうか。]。
     * デフォルト: [false]。
     *
     * @return フィールド[verbose]から取得した値。
     */
    public boolean getVerbose() {
        return fVerbose;
    }

    /**
     * フィールド [targetdir] の値を設定します。
     *
     * フィールドの説明: [適用先 XLIFF が格納されているディレクトリ。]。
     *
     * @param argTargetdir フィールド[targetdir]に設定する値。
     */
    public void setTargetdir(final String argTargetdir) {
        fTargetdir = argTargetdir;
    }

    /**
     * フィールド [targetdir] の値を取得します。
     *
     * フィールドの説明: [適用先 XLIFF が格納されているディレクトリ。]。
     *
     * @return フィールド[targetdir]から取得した値。
     */
    public String getTargetdir() {
        return fTargetdir;
    }

    /**
     * フィールド [sourcedir] の値を設定します。
     *
     * フィールドの説明: [適用元(過去訳) XLIFF が格納されているディレクトリ。]。
     *
     * @param argSourcedir フィールド[sourcedir]に設定する値。
     */
    public void setSourcedir(final String argSourcedir) {
        fSourcedir = argSourcedir;
    }

    /**
     * フィールド [sourcedir] の値を取得します。
     *
     * フィールドの説明: [適用元(過去訳) XLIFF が格納されているディレクトリ。]。
     *
     * @return フィールド[sourcedir]から取得した値。
     */
    public String getSourcedir() {
        return fSourcedir;
    }

    /**
     * フィールド [transsourcelang] の値を設定します。
     *
     * フィールドの説明: [翻訳元言語]。
     *
     * @param argTranssourcelang フィールド[transsourcelang]に設定する値。
     */
    public void setTranssourcelang(final String argTranssourcelang) {
        fTranssourcelang = argTranssourcelang;
    }

    /**
     * フィールド [transsourcelang] の値を取得します。
     *
     * フィールドの説明: [翻訳元言語]。
     * デフォルト: [en-US]。
     *
     * @return フィールド[transsourcelang]から取得した値。
     */
    public String getTranssourcelang() {
        return fTranssourcelang;
    }

    /**
     * フィールド [transtargetlang] の値を設定します。
     *
     * フィールドの説明: [翻訳先言語]。
     *
     * @param argTranstargetlang フィールド[transtargetlang]に設定する値。
     */
    public void setTranstargetlang(final String argTranstargetlang) {
        fTranstargetlang = argTranstargetlang;
    }

    /**
     * フィールド [transtargetlang] の値を取得します。
     *
     * フィールドの説明: [翻訳先言語]。
     * デフォルト: [ja-JP]。
     *
     * @return フィールド[transtargetlang]から取得した値。
     */
    public String getTranstargetlang() {
        return fTranstargetlang;
    }

    /**
     * フィールド [tmdriverclassname] の値を設定します。
     *
     * フィールドの説明: [Ant タスクの場合には、TM ドライバーのクラス名を指定します。]。
     *
     * @param argTmdriverclassname フィールド[tmdriverclassname]に設定する値。
     */
    public void setTmdriverclassname(final String argTmdriverclassname) {
        fTmdriverclassname = argTmdriverclassname;
    }

    /**
     * フィールド [tmdriverclassname] の値を取得します。
     *
     * フィールドの説明: [Ant タスクの場合には、TM ドライバーのクラス名を指定します。]。
     *
     * @return フィールド[tmdriverclassname]から取得した値。
     */
    public String getTmdriverclassname() {
        return fTmdriverclassname;
    }

    /**
     * フィールド [ignorewhitespacetmreference] の値を設定します。
     *
     * フィールドの説明: [TMX を検索する際にホワイトスペースを無視するかどうか。]。
     *
     * @param argIgnorewhitespacetmreference フィールド[ignorewhitespacetmreference]に設定する値。
     */
    public void setIgnorewhitespacetmreference(final boolean argIgnorewhitespacetmreference) {
        fIgnorewhitespacetmreference = argIgnorewhitespacetmreference;
    }

    /**
     * フィールド [ignorewhitespacetmreference] の値を取得します。
     *
     * フィールドの説明: [TMX を検索する際にホワイトスペースを無視するかどうか。]。
     * デフォルト: [false]。
     *
     * @return フィールド[ignorewhitespacetmreference]から取得した値。
     */
    public boolean getIgnorewhitespacetmreference() {
        return fIgnorewhitespacetmreference;
    }

    /**
     * フィールド [ignoremnemonickeytmreference] の値を設定します。
     *
     * フィールドの説明: [TMX を検索する際にニーモニックを無視するかどうか。]。
     *
     * @param argIgnoremnemonickeytmreference フィールド[ignoremnemonickeytmreference]に設定する値。
     */
    public void setIgnoremnemonickeytmreference(final boolean argIgnoremnemonickeytmreference) {
        fIgnoremnemonickeytmreference = argIgnoremnemonickeytmreference;
    }

    /**
     * フィールド [ignoremnemonickeytmreference] の値を取得します。
     *
     * フィールドの説明: [TMX を検索する際にニーモニックを無視するかどうか。]。
     * デフォルト: [false]。
     *
     * @return フィールド[ignoremnemonickeytmreference]から取得した値。
     */
    public boolean getIgnoremnemonickeytmreference() {
        return fIgnoremnemonickeytmreference;
    }

    /**
     * フィールド [tmpdir] の値を設定します。
     *
     * フィールドの説明: [テンポラリ・ディレクトリ]。
     *
     * @param argTmpdir フィールド[tmpdir]に設定する値。
     */
    public void setTmpdir(final String argTmpdir) {
        fTmpdir = argTmpdir;
    }

    /**
     * フィールド [tmpdir] の値を取得します。
     *
     * フィールドの説明: [テンポラリ・ディレクトリ]。
     * デフォルト: ["./tmp"]。
     *
     * @return フィールド[tmpdir]から取得した値。
     */
    public String getTmpdir() {
        return fTmpdir;
    }

    /**
     * このバリューオブジェクトの文字列表現を取得します。
     *
     * <P>使用上の注意</P>
     * <UL>
     * <LI>オブジェクトのシャロー範囲のみ文字列化の処理対象となります。
     * <LI>オブジェクトが循環参照している場合には、このメソッドは使わないでください。
     * </UL>
     *
     * @return バリューオブジェクトの文字列表現。
     */
    @Override
    public String toString() {
        final StringBuffer buf = new StringBuffer();
        buf.append("benten.twa.cat.core.valueobject.BentenApplyExistentTranslationProcessInput[");
        buf.append("verbose=" + fVerbose);
        buf.append(",targetdir=" + fTargetdir);
        buf.append(",sourcedir=" + fSourcedir);
        buf.append(",transsourcelang=" + fTranssourcelang);
        buf.append(",transtargetlang=" + fTranstargetlang);
        buf.append(",tmdriverclassname=" + fTmdriverclassname);
        buf.append(",ignorewhitespacetmreference=" + fIgnorewhitespacetmreference);
        buf.append(",ignoremnemonickeytmreference=" + fIgnoremnemonickeytmreference);
        buf.append(",tmpdir=" + fTmpdir);
        buf.append("]");
        return buf.toString();
    }
}
