/*******************************************************************************
 * Copyright (c) 2009 Information-technology Promotion Agency, Japan.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *******************************************************************************/
package benten.twa.cat.dialogs;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Shell;

import benten.twa.BentenTwaConstants;
import benten.twa.cat.messages.BentenMarkNoTransableMessages;
import benten.twa.cat.status.BentenMarkNoTransableStatus;
import benten.twa.ui.dialogs.AbstractWorkflowDialog;
import benten.ui.UiStatus;
import benten.ui.UiStatusException;
import benten.ui.fields.ResourceFolderTextField;

/**
 * 翻訳対象外のマーク
 *
 * <pre>
 * XLIFF 内の翻訳の必要のない翻訳単位を、翻訳対象外としてマークします。
 *   1.  XLIFF の翻訳単位の内容から、翻訳の必要の有無を判断します。
 *   2.  翻訳の必要がないと判断されたものについて、翻訳対象外としてマークします。
 * </pre>
 *
 * ★基本設計「翻訳ワークフロー支援機能: 翻訳中間形式機械支援翻訳機能: 非翻訳対象マーク機能」に対応します。
 *
 * @author IGA Tosiki
 */
public class MarkNoTransableDialog extends AbstractWorkflowDialog {

	/**
	 * 翻訳対象外マーク機能のためのメッセージ。
	 */
	protected static final BentenMarkNoTransableMessages fMsg = new BentenMarkNoTransableMessages();

	/** コントロール・コンテナー */
	private final MarkNoTransableControls controls = new MarkNoTransableControls();

	/** コントロール・コンテナー・クラス */
	public static class MarkNoTransableControls {

		/** ターゲット・ディレクトリー・テキスト */
		public ResourceFolderTextField targetDirText;
	}

	/**
	 * コンストラクター。
	 * @param parentShell 親シェル
	 * @param selection 選択
	 */
	public MarkNoTransableDialog(final Shell parentShell, final IStructuredSelection selection) {
		super(parentShell, selection, fMsg.getWindowTitle());
	}

	@Override
	public void createControls(final Composite composite) {
		composite.setLayout(new GridLayout(3, false));

		controls.targetDirText = new ResourceFolderTextField(composite, fMsg.getDialogCtrlLabelTargetXliffDir());
		controls.targetDirText.addModifyListener(this);
		if (getSelectionResource() != null) {
			controls.targetDirText.setText(getSelectionResource().getProject().getName()
					+ "/" + BentenTwaConstants.DEFAULT_XLIFF_DIR); //$NON-NLS-1$
		}
	}

	@Override
	public IStatus getResultStatus() {
		final BentenMarkNoTransableStatus status = new BentenMarkNoTransableStatus();
		status.setTargetDir(controls.targetDirText.getFile());
		status.setProject(controls.targetDirText.getResource());
		return status;
	}

	@Override
	public IStatus validate() throws UiStatusException {
		validatePath(controls.targetDirText);
		return UiStatus.OK_STATUS;
	}
}
